/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmpt;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.mina.common.ByteBuffer;
import org.red5.server.api.Red5;
import org.red5.server.net.protocol.SimpleProtocolDecoder;
import org.red5.server.net.protocol.SimpleProtocolEncoder;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPHandler;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmpt.RTMPTHandler;
import org.red5.server.net.rtmpt.RTMPTServlet;
import org.red5.server.net.servlet.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPTConnection
extends RTMPConnection {
    protected static Logger log = LoggerFactory.getLogger((String)RTMPTConnection.class.getName());
    protected static final long INCREASE_POLLING_DELAY_COUNT = 10L;
    protected static final byte INITIAL_POLLING_DELAY = 0;
    protected static final byte MAX_POLLING_DELAY = 32;
    protected SimpleProtocolDecoder decoder;
    protected SimpleProtocolEncoder encoder;
    protected RTMPHandler handler;
    protected ByteBuffer buffer;
    protected List<ByteBuffer> pendingMessages = new LinkedList<ByteBuffer>();
    protected List<Object> notifyMessages = new LinkedList<Object>();
    protected byte pollingDelay = 0;
    protected long noPendingMessages;
    protected long readBytes;
    protected long writtenBytes;
    protected volatile boolean closing;
    protected RTMPTServlet servlet;

    RTMPTConnection() {
        super("polling");
    }

    void setRTMPTHandle(RTMPTHandler handler) {
        this.state = new RTMP(false);
        this.buffer = ByteBuffer.allocate((int)2048);
        this.buffer.setAutoExpand(true);
        this.handler = handler;
        this.decoder = handler.getCodecFactory().getSimpleDecoder();
        this.encoder = handler.getCodecFactory().getSimpleEncoder();
        this.clientId = this.hashCode();
    }

    public void close() {
        this.closing = true;
    }

    protected void setServlet(RTMPTServlet servlet) {
        this.servlet = servlet;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void realClose() {
        if (!this.isClosing()) {
            return;
        }
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
        this.notifyMessages.clear();
        this.state.setState((byte)4);
        super.close();
        for (ByteBuffer buf : this.pendingMessages) {
            buf.release();
        }
        this.pendingMessages.clear();
        if (this.servlet != null) {
            this.servlet.notifyClosed(this);
            this.servlet = null;
        }
    }

    protected void onInactive() {
        this.close();
        this.realClose();
    }

    public void setServletRequest(HttpServletRequest request) {
        this.host = request.getLocalName();
        this.remoteAddress = request.getRemoteAddr();
        this.remoteAddresses = ServletUtils.getRemoteAddresses(request);
        this.remotePort = request.getRemotePort();
    }

    public byte getPollingDelay() {
        if (this.state.getState() == 4) {
            return 0;
        }
        return (byte)(this.pollingDelay + 1);
    }

    public List decode(ByteBuffer data) {
        if (this.closing || this.state.getState() == 4) {
            return Collections.EMPTY_LIST;
        }
        Red5.setConnectionLocal(this);
        this.readBytes += (long)data.limit();
        this.buffer.put(data);
        this.buffer.flip();
        return this.decoder.decodeBuffer(this.state, this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(Packet packet) {
        ByteBuffer data;
        if (this.closing || this.state.getState() == 4) {
            return;
        }
        try {
            data = this.encoder.encode(this.state, packet);
        }
        catch (Exception e) {
            log.error("Could not encode message " + packet, (Throwable)e);
            return;
        }
        this.writingMessage(packet);
        this.rawWrite(data);
        List<Object> list = this.notifyMessages;
        synchronized (list) {
            this.notifyMessages.add(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rawWrite(ByteBuffer packet) {
        List<ByteBuffer> list = this.pendingMessages;
        synchronized (list) {
            this.pendingMessages.add(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getPendingMessages(int targetSize) {
        if (this.pendingMessages.isEmpty()) {
            ++this.noPendingMessages;
            if (this.noPendingMessages > 10L) {
                if (this.pollingDelay == 0) {
                    this.pollingDelay = 1;
                }
                this.pollingDelay = (byte)(this.pollingDelay * 2);
                if (this.pollingDelay > 32) {
                    this.pollingDelay = (byte)32;
                }
            }
            return null;
        }
        ByteBuffer result = ByteBuffer.allocate((int)2048);
        result.setAutoExpand(true);
        if (log.isDebugEnabled()) {
            log.debug("Returning " + this.pendingMessages.size() + " messages to client.");
        }
        this.noPendingMessages = 0L;
        this.pollingDelay = 0;
        while (result.limit() < targetSize && !this.pendingMessages.isEmpty()) {
            List<ByteBuffer> list = this.pendingMessages;
            synchronized (list) {
                for (ByteBuffer byteBuffer : this.pendingMessages) {
                    result.put(byteBuffer);
                    byteBuffer.release();
                }
                this.pendingMessages.clear();
            }
            LinkedList<Object> toNotify = new LinkedList<Object>();
            Iterator i$ = this.notifyMessages;
            synchronized (i$) {
                toNotify.addAll(this.notifyMessages);
                this.notifyMessages.clear();
            }
            for (Object e : toNotify) {
                try {
                    this.handler.messageSent(this, e);
                }
                catch (Exception e2) {
                    log.error("Could not notify stream subsystem about sent message.", (Throwable)e2);
                }
            }
        }
        result.flip();
        this.writtenBytes += (long)result.limit();
        return result;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    public long getPendingMessages() {
        return this.pendingMessages.size();
    }
}

