/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmpt;

import org.apache.mina.common.ByteBuffer;
import org.red5.server.net.protocol.ProtocolState;
import org.red5.server.net.protocol.SimpleProtocolCodecFactory;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPHandler;
import org.red5.server.net.rtmp.codec.RTMP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPTHandler
extends RTMPHandler {
    protected static Logger log = LoggerFactory.getLogger(RTMPTHandler.class);
    public static final String HANDLER_ATTRIBUTE = "red5.RMPTHandler";
    protected SimpleProtocolCodecFactory codecFactory;

    public void setCodecFactory(SimpleProtocolCodecFactory factory) {
        this.codecFactory = factory;
    }

    public SimpleProtocolCodecFactory getCodecFactory() {
        return this.codecFactory;
    }

    private void rawBufferRecieved(RTMPConnection conn, ProtocolState state, ByteBuffer in) {
        RTMP rtmp = (RTMP)state;
        if (rtmp.getState() != 1) {
            log.warn("Raw buffer after handshake, something odd going on");
        }
        ByteBuffer out = ByteBuffer.allocate((int)3073);
        if (log.isDebugEnabled()) {
            log.debug("Writing handshake reply");
            log.debug("handskake size:" + in.remaining());
        }
        out.put((byte)3);
        out.putInt(1);
        out.fill((byte)0, 1532);
        out.put(in).flip();
        rtmp.setHandshake(out, 9, 1528);
        conn.rawWrite(out);
    }

    public void messageReceived(RTMPConnection conn, ProtocolState state, Object in) throws Exception {
        if (in instanceof ByteBuffer) {
            this.rawBufferRecieved(conn, state, (ByteBuffer)in);
            ((ByteBuffer)in).release();
            in = null;
        } else {
            super.messageReceived(conn, state, in);
        }
    }
}

