/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.mina.common.ByteBuffer;
import org.red5.server.api.IContext;
import org.red5.server.api.IGlobalScope;
import org.red5.server.api.IScope;
import org.red5.server.api.IServer;
import org.red5.server.api.Red5;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.service.IServiceInvoker;
import org.red5.server.net.remoting.RemotingConnection;
import org.red5.server.net.remoting.codec.RemotingCodecFactory;
import org.red5.server.net.remoting.message.RemotingCall;
import org.red5.server.net.remoting.message.RemotingPacket;
import org.red5.server.net.servlet.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AMFGatewayServlet
extends HttpServlet {
    private static final long serialVersionUID = 7174018823796785619L;
    protected static Logger log = LoggerFactory.getLogger(AMFGatewayServlet.class);
    public static final String APPLICATION_AMF = "application/x-amf";
    protected WebApplicationContext webAppCtx;
    protected IServer server;
    protected RemotingCodecFactory codecFactory;
    private static final String CONNECTION = "red5.remotingConnection";

    public void init() throws ServletException {
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.debug("Servicing Request");
        if (this.codecFactory == null) {
            ServletContext ctx = this.getServletContext();
            log.debug("Context path: {}", (Object)ctx.getContextPath());
            this.webAppCtx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)ctx);
            if (this.webAppCtx == null) {
                log.debug("Webapp context was null, trying lookup as attr.");
                this.webAppCtx = (WebApplicationContext)ctx.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            }
            if (this.webAppCtx != null) {
                this.server = (IServer)this.webAppCtx.getBean("red5.server");
                this.codecFactory = (RemotingCodecFactory)this.webAppCtx.getBean("remotingCodecFactory");
            } else {
                log.debug("No web context");
            }
        }
        log.debug("Remoting request {} {}", (Object)req.getContextPath(), (Object)req.getServletPath());
        if (req.getContentType() != null && req.getContentType().equals(APPLICATION_AMF)) {
            this.serviceAMF(req, resp);
        } else {
            resp.getWriter().write("Red5 : Remoting Gateway");
        }
    }

    protected IGlobalScope getGlobalScope(HttpServletRequest req) {
        String path = req.getContextPath() + req.getServletPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        path = path.substring(0, path.length() - this.getServletName().length() - 1);
        IGlobalScope global = this.server.lookupGlobal(req.getServerName(), path);
        if (global == null && (global = this.server.lookupGlobal(req.getLocalName(), path)) == null) {
            global = this.server.lookupGlobal(req.getLocalAddr(), path);
        }
        return global;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceAMF(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.debug("Servicing AMF");
        try {
            RemotingPacket packet = this.decodeRequest(req);
            if (packet == null) {
                log.error("Packet should not be null");
                return;
            }
            IGlobalScope global = this.getGlobalScope(req);
            IContext context = global.getContext();
            IScope scope = context.resolveScope(global, packet.getScopePath());
            RemotingConnection conn = new RemotingConnection(req, scope, packet);
            req.setAttribute(CONNECTION, (Object)conn);
            try {
                Red5.setConnectionLocal(conn);
                this.handleRemotingPacket(req, context, scope, packet);
                resp.setStatus(200);
                resp.setContentType(APPLICATION_AMF);
                this.sendResponse(resp, packet);
            }
            finally {
                req.removeAttribute(CONNECTION);
            }
        }
        catch (Exception e) {
            log.error("Error handling remoting call", (Throwable)e);
            resp.setStatus(500);
        }
    }

    protected RemotingPacket decodeRequest(HttpServletRequest req) throws Exception {
        String headerPath;
        log.debug("Decoding request");
        ByteBuffer reqBuffer = ByteBuffer.allocate((int)req.getContentLength());
        ServletUtils.copy((InputStream)req.getInputStream(), reqBuffer.asOutputStream());
        reqBuffer.flip();
        RemotingPacket packet = (RemotingPacket)this.codecFactory.getSimpleDecoder().decode(null, reqBuffer);
        String path = req.getContextPath();
        if (path == null) {
            path = "";
        }
        if (req.getPathInfo() != null) {
            path = path + req.getPathInfo();
        }
        if ((headerPath = req.getHeader("Tunnel-request")) != null && path.length() < 1) {
            path = headerPath;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        log.debug("Path: {} Scope path: {}", (Object)path, (Object)packet.getScopePath());
        packet.setScopePath(path);
        reqBuffer.release();
        reqBuffer = null;
        return packet;
    }

    protected boolean handleRemotingPacket(HttpServletRequest req, IContext context, IScope scope, RemotingPacket message) {
        log.debug("Handling remoting packet");
        IServiceInvoker invoker = context.getServiceInvoker();
        for (RemotingCall call : message.getCalls()) {
            invoker.invoke((IServiceCall)call, scope);
        }
        return true;
    }

    protected void sendResponse(HttpServletResponse resp, RemotingPacket packet) throws Exception {
        log.debug("Sending response");
        ByteBuffer respBuffer = this.codecFactory.getSimpleEncoder().encode(null, packet);
        ServletOutputStream out = resp.getOutputStream();
        resp.setContentLength(respBuffer.limit());
        ServletUtils.copy(respBuffer.asInputStream(), (OutputStream)out);
        out.flush();
        out.close();
        respBuffer.release();
        respBuffer = null;
    }
}

