/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;
import org.red5.server.net.servlet.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZAMFGatewayServlet
extends HttpServlet {
    private static final long serialVersionUID = 8763226003362000834L;
    protected static Logger log = LoggerFactory.getLogger((String)ZAMFGatewayServlet.class.getName());
    public static final String APPLICATION_AMF = "application/x-amf";

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.info("Service");
        if (req.getContentLength() == 0 || req.getContentType() == null || !req.getContentType().equals(APPLICATION_AMF)) {
            resp.setStatus(200);
            resp.getWriter().write("Gateway");
            resp.flushBuffer();
            return;
        }
        ByteBuffer reqBuffer = null;
        try {
            reqBuffer = ByteBuffer.allocate((int)req.getContentLength());
            ServletUtils.copy((InputStream)req.getInputStream(), reqBuffer.asOutputStream());
            reqBuffer.flip();
            VmPipeConnector connector = new VmPipeConnector();
            Handler handler = new Handler(req, resp);
            ConnectFuture connectFuture = connector.connect((SocketAddress)new VmPipeAddress(5080), (IoHandler)handler);
            connectFuture.join();
            IoSession session = connectFuture.getSession();
            session.setAttachment((Object)resp);
            session.write((Object)reqBuffer);
            ContinuationSupport.getContinuation((HttpServletRequest)req, (Object)((Object)handler)).suspend(1000L);
        }
        catch (IOException e) {
            log.error("{}", (Throwable)e);
        }
        log.info("End");
    }

    protected class Handler
    extends IoHandlerAdapter {
        protected HttpServletResponse resp;
        protected HttpServletRequest req;

        public Handler(HttpServletRequest req, HttpServletResponse resp) {
            this.req = req;
            this.resp = resp;
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            log.info("<< message " + message);
            if (message instanceof ByteBuffer) {
                Continuation cont = ContinuationSupport.getContinuation((HttpServletRequest)this.req, (Object)((Object)this));
                if (cont.isPending()) {
                    cont.resume();
                }
                try {
                    ServletOutputStream out = this.resp.getOutputStream();
                    ByteBuffer buf = (ByteBuffer)message;
                    this.resp.setStatus(200);
                    this.resp.setContentType(this.req.getContentType());
                    this.resp.setContentLength(buf.limit());
                    ServletUtils.copy(buf.asInputStream(), (OutputStream)out);
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    log.error("Error sending response", (Throwable)e);
                }
            }
        }
    }
}

