/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.persistence;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.red5.server.api.persistence.IPersistable;
import org.red5.server.persistence.FilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePersistenceThread
implements Runnable {
    private Logger log = LoggerFactory.getLogger(FilePersistenceThread.class);
    private long storeInterval = 10000L;
    private Map<UpdateEntry, FilePersistence> objects = new ConcurrentHashMap<UpdateEntry, FilePersistence>();
    private static volatile FilePersistenceThread instance = null;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public static FilePersistenceThread getInstance() {
        return instance;
    }

    private FilePersistenceThread() {
        if (instance != null) {
            this.log.error("Instance was not null, this is not a good sign");
        }
        instance = this;
        ScheduledFuture<?> instanceHandle = this.scheduler.scheduleAtFixedRate(this, this.storeInterval, this.storeInterval, TimeUnit.MILLISECONDS);
    }

    protected void modified(IPersistable object, FilePersistence store) {
        FilePersistence previous = this.objects.put(new UpdateEntry(object, store), store);
        if (previous != null && !previous.equals(store)) {
            this.log.warn("Object {} was also modified in {}, saving instantly", new Object[]{object, previous});
            previous.saveObject(object);
        }
    }

    protected void notifyClose(FilePersistence store) {
        for (UpdateEntry entry : this.objects.keySet()) {
            if (!store.equals(entry.store)) continue;
            try {
                this.objects.remove(entry);
                store.saveObject(entry.object);
            }
            catch (Throwable e) {
                this.log.error("Error while saving {} in {}. {}", new Object[]{entry.object, store, e});
            }
        }
    }

    public void run() {
        if (this.objects.isEmpty()) {
            return;
        }
        for (UpdateEntry entry : this.objects.keySet()) {
            try {
                this.objects.remove(entry);
                entry.store.saveObject(entry.object);
            }
            catch (Throwable e) {
                this.log.error("Error while saving {} in {}. {}", new Object[]{entry.object, entry.store, e});
            }
        }
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }

    private class UpdateEntry {
        IPersistable object;
        FilePersistence store;

        UpdateEntry(IPersistable object, FilePersistence store) {
            this.object = object;
            this.store = store;
        }

        public boolean equals(Object other) {
            if (!(other instanceof UpdateEntry)) {
                return false;
            }
            return this.object.equals(((UpdateEntry)other).object) && this.store.equals(((UpdateEntry)other).store);
        }

        public int hashCode() {
            return this.object.hashCode() + this.store.hashCode();
        }
    }
}

