/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.pooling;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.red5.server.jmx.JMXAgent;
import org.red5.server.pooling.ThreadPoolMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPool
implements ThreadPoolMBean {
    private static final Logger log = LoggerFactory.getLogger(ThreadPool.class);
    private ExecutorService pool;
    private Executor executor;
    private int poolSize;

    public ThreadPool() {
        JMXAgent.registerMBean((Object)this, this.getClass().getName(), ThreadPoolMBean.class, "threadpool");
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
        if (this.pool == null) {
            this.pool = Executors.newFixedThreadPool(poolSize);
        }
    }

    public void execute(Runnable command) {
        this.pool.execute(command);
    }

    public void shutdown() {
        this.pool.shutdown();
    }
}

