/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.pooling;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Worker
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(Worker.class);
    private String className;
    private String methodName;
    private Object[] methodParams;
    private Class<?>[] paramTypes;
    private Object result;

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Object[] getMethodParams() {
        return this.methodParams;
    }

    public void setMethodParams(Object[] methodParams) {
        this.methodParams = methodParams;
    }

    public Class<?>[] getParamTypes() {
        return this.paramTypes;
    }

    public void setParamTypes(Class<?>[] paramTypes) {
        this.paramTypes = paramTypes;
    }

    public synchronized void execute(String clsName, String methName, Object[] params, Class<?>[] paramTypes, Object synObj) {
        this.className = clsName;
        this.methodName = methName;
        this.methodParams = params;
        this.paramTypes = paramTypes;
    }

    @Override
    public void run() {
        try {
            Class<?> cls = Worker.getClass(this.getClassName());
            Object obj = cls.newInstance();
            this.result = MethodUtils.invokeExactMethod(obj, (String)this.getMethodName(), (Object[])this.getMethodParams(), (Class[])this.getParamTypes());
            if (log.isDebugEnabled()) {
                log.debug(" #### Execution Result = " + this.result + " for : " + this);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("ClassNotFoundException - " + e);
        }
        catch (NoSuchMethodException e) {
            log.error("NoSuchMethodException - " + e);
        }
        catch (IllegalAccessException e) {
            log.error("IllegalAccessException - " + e);
        }
        catch (InvocationTargetException e) {
            log.error("InvocationTargetException - " + e);
        }
        catch (InstantiationException e) {
            log.error("InstantiationException - " + e);
        }
    }

    public void reset() {
        this.className = null;
        this.methodName = null;
        this.methodParams = null;
        this.paramTypes = null;
    }

    private static Class<?> getClass(String cls) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = Worker.class.getClassLoader();
        }
        return classLoader.loadClass(cls);
    }
}

