/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.script.jython;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.python.core.Py;
import org.python.core.PyFunction;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;

public class JythonScriptFactory
implements ScriptFactory {
    private static Logger logger = LoggerFactory.getLogger(JythonScriptFactory.class);
    private final String scriptSourceLocator;
    private final Class[] scriptInterfaces;
    private final Object[] arguments;

    public JythonScriptFactory(String scriptSourceLocator) {
        Assert.hasText((String)scriptSourceLocator);
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = new Class[0];
        this.arguments = null;
    }

    public JythonScriptFactory(String scriptSourceLocator, Class[] scriptInterfaces) {
        Assert.hasText((String)scriptSourceLocator);
        Assert.notEmpty((Object[])scriptInterfaces);
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = scriptInterfaces;
        this.arguments = null;
    }

    public JythonScriptFactory(String scriptSourceLocator, Class[] scriptInterfaces, Object[] arguments) {
        Assert.hasText((String)scriptSourceLocator);
        Assert.notEmpty((Object[])scriptInterfaces);
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = scriptInterfaces;
        this.arguments = arguments == null || arguments.length == 0 ? null : arguments;
    }

    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    public Class[] getScriptInterfaces() {
        return this.scriptInterfaces;
    }

    public boolean requiresConfigInterface() {
        return true;
    }

    public Object getScriptedObject(ScriptSource scriptSourceLocator, Class[] scriptInterfaces) throws IOException, ScriptCompilationException {
        File root;
        ContextHandler handler = WebAppContext.getCurrentWebAppContext();
        String basePath = "";
        if (handler != null && (root = handler.getBaseResource().getFile()) != null && root.exists()) {
            basePath = root.getAbsolutePath() + File.separator + "WEB-INF" + File.separator;
        }
        String strScript = scriptSourceLocator.getScriptAsString();
        if (scriptInterfaces.length > 0) {
            try {
                PyObject _this;
                PySystemState state = new PySystemState();
                if (!"".equals(basePath)) {
                    state.path.insert(0, (PyObject)Py.newString((String)(basePath + "classes")));
                    File jarRoot = new File(basePath + "lib");
                    if (jarRoot.exists()) {
                        for (String filename : jarRoot.list(new FilenameFilter(){

                            public boolean accept(File dir, String name) {
                                return name.endsWith(".jar");
                            }
                        })) {
                            state.path.insert(1, (PyObject)Py.newString((String)(basePath + "lib" + File.separator + filename)));
                        }
                    }
                }
                PythonInterpreter interp = new PythonInterpreter(null, state);
                interp.exec(strScript);
                PyObject getInstance = interp.get("getInstance");
                if (!(getInstance instanceof PyFunction)) {
                    throw new ScriptCompilationException("\"getInstance\" is not a function.");
                }
                if (this.arguments == null) {
                    _this = ((PyFunction)getInstance).__call__();
                } else {
                    PyObject[] args = new PyObject[this.arguments.length];
                    for (int i = 0; i < this.arguments.length; ++i) {
                        args[i] = new PyJavaInstance(this.arguments[i]);
                    }
                    _this = ((PyFunction)getInstance).__call__(args);
                }
                return _this.__tojava__(scriptInterfaces[0]);
            }
            catch (Exception ex) {
                logger.error("Error while loading script.", (Throwable)ex);
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof ScriptCompilationException) {
                    throw (ScriptCompilationException)ex;
                }
                throw new ScriptCompilationException(ex.getMessage());
            }
        }
        logger.error("No scriptInterfaces provided.");
        return null;
    }

    public Class getScriptedObjectType(ScriptSource arg0) throws IOException, ScriptCompilationException {
        return null;
    }
}

