/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.script.rhino;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.regex.PatternSyntaxException;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.util.ClassUtils;

public class RhinoScriptUtils {
    private static final Logger log = LoggerFactory.getLogger(RhinoScriptUtils.class);
    private static ScriptEngineManager mgr = new ScriptEngineManager();
    private static final String jsWrapper = "function Wrapper(obj){return new JSAdapter(){ __has__ : function(name){return true;}, __get__ : function(name){if(name in obj){return obj[name];}else if(typeof(obj['doesNotUnderstand']) == 'function'){return function(){return obj.doesNotUnderstand(name, arguments);}}else{return undefined;}}};}";

    public static Object createRhinoObject(String scriptSource, Class[] interfaces, Class extendedClass) throws ScriptCompilationException, IOException, Exception {
        ScriptEngine engine;
        if (log.isDebugEnabled()) {
            log.debug("Script Engine Manager: " + mgr.getClass().getName());
        }
        if (null == (engine = mgr.getEngineByExtension("js"))) {
            log.warn("Javascript is not supported in this build");
        }
        Bindings nameSpace = engine.getBindings(100);
        nameSpace.put("log", (Object)log);
        CompiledScript wrapper = ((Compilable)((Object)engine)).compile(jsWrapper);
        nameSpace.put("Wrapper", (Object)wrapper);
        String funcName = RhinoScriptUtils.getFunctionName(scriptSource);
        if (log.isDebugEnabled()) {
            log.debug("New script: " + funcName);
        }
        nameSpace.put("javax.script.filename", (Object)funcName);
        if (null != interfaces) {
            nameSpace.put("interfaces", (Object)interfaces);
        }
        if (null != extendedClass) {
            if (log.isDebugEnabled()) {
                log.debug("Extended: " + extendedClass.getName());
            }
            nameSpace.put("supa", extendedClass.newInstance());
        }
        CompiledScript script = ((Compilable)((Object)engine)).compile(scriptSource);
        Object o = null;
        try {
            o = script.eval();
        }
        catch (Exception e) {
            log.error("Problem evaluating script", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Result of script call: " + o);
        }
        if (null == o) {
            wrapper.eval();
        } else {
            wrapper.eval();
            o = ((Invocable)((Object)engine)).invokeFunction("Wrapper", engine.get(funcName));
            if (log.isDebugEnabled()) {
                log.debug("Result of invokeFunction: " + o);
            }
        }
        return Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(), interfaces, (InvocationHandler)new RhinoObjectInvocationHandler(engine, o));
    }

    private static String getFunctionName(String scriptSource) {
        String ret = "undefined";
        try {
            ret = scriptSource.replaceAll("[\\S\\w\\s]*?function ([\\w]+)\\(\\)[\\S\\w\\s]+", "$1");
            if (ret.equals("undefined") || ret.length() > 64) {
                ret = scriptSource.replaceAll("[\\S\\w\\s]*?var ([\\w]+)[\\S\\w\\s]+", "$1");
            }
        }
        catch (PatternSyntaxException ex) {
            log.error("Syntax error in the regular expression");
        }
        catch (IllegalArgumentException ex) {
            log.error("Syntax error in the replacement text (unescaped $ signs?)");
        }
        catch (IndexOutOfBoundsException ex) {
            log.error("Non-existent backreference used the replacement text");
        }
        log.debug("Got a function name: " + ret);
        return ret;
    }

    private static class RhinoObjectInvocationHandler
    implements InvocationHandler {
        private final ScriptEngine engine;
        private final Object instance;

        public RhinoObjectInvocationHandler(ScriptEngine engine, Object instance) {
            this.engine = engine;
            this.instance = instance;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object o = null;
            if (args == null || args.length == 0) {
                args = new Object[]{""};
            }
            String name = method.getName();
            if (log.isDebugEnabled()) {
                log.debug("Calling: " + name);
            }
            try {
                Object apiMethod = null;
                Invocable invocable = (Invocable)((Object)this.engine);
                if (null == this.instance) {
                    o = invocable.invokeFunction(name, args);
                } else {
                    try {
                        o = invocable.invokeMethod(this.instance, name, args);
                    }
                    catch (NoSuchMethodException nex) {
                        log.debug("Method not found: " + name);
                        try {
                            o = invocable.invokeFunction(name, args);
                        }
                        catch (Exception ex) {
                            Class[] interfaces;
                            log.debug("Function not found: " + name);
                            for (Class clazz : interfaces = (Class[])this.engine.get("interfaces")) {
                                o = invocable.getInterface(this.engine.get((String)this.engine.get("className")), clazz);
                                if (null == o) continue;
                                log.debug("Interface return type: " + o.getClass().getName());
                                break;
                            }
                        }
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Invocable result: " + o);
                }
            }
            catch (NoSuchMethodException nex) {
                log.warn("Method not found");
            }
            catch (Throwable t) {
                log.warn("{}", t);
            }
            return o;
        }
    }
}

