/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.service;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConversionException;
import org.red5.io.object.Deserializer;
import org.red5.server.api.IConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionUtils {
    protected static Logger log = LoggerFactory.getLogger(Deserializer.class);
    private static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final Class<?>[] WRAPPERS = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
    private static final Class<?>[][] PARAMETER_CHAINS = new Class[][]{{Boolean.TYPE, null}, {Byte.TYPE, Short.class}, {Character.TYPE, Integer.class}, {Short.TYPE, Integer.class}, {Integer.TYPE, Long.class}, {Long.TYPE, Float.class}, {Float.TYPE, Double.class}, {Double.TYPE, null}};
    private static Map<Class<?>, Class<?>> primitiveMap = new HashMap();
    private static Map<Class<?>, Class<?>> wrapperMap = new HashMap();
    private static Map<Class<?>, Class<?>[]> parameterMap = new HashMap();

    public static Object convert(Object source, Class<?> target) throws ConversionException {
        if (target == null) {
            throw new ConversionException("Unable to perform conversion");
        }
        if (source == null) {
            if (target.isPrimitive()) {
                throw new ConversionException("Unable to convert null to primitive value");
            }
            return source;
        }
        if (source instanceof Float && ((Float)source).isNaN() || source instanceof Double && ((Double)source).isNaN()) {
            return source;
        }
        if (IConnection.class.isAssignableFrom(source.getClass()) && !target.equals(IConnection.class)) {
            throw new ConversionException("IConnection must match exact.");
        }
        if (target.isInstance(source)) {
            return source;
        }
        if (target.isAssignableFrom(source.getClass())) {
            return source;
        }
        if (target.isArray()) {
            return ConversionUtils.convertToArray(source, target);
        }
        if (target.equals(String.class)) {
            return source.toString();
        }
        if (target.isPrimitive()) {
            return ConversionUtils.convertToWrappedPrimitive(source, primitiveMap.get(target));
        }
        if (wrapperMap.containsKey(target)) {
            return ConversionUtils.convertToWrappedPrimitive(source, target);
        }
        if (target.equals(Map.class)) {
            return ConversionUtils.convertBeanToMap(source);
        }
        if (target.equals(List.class) || target.equals(Collection.class)) {
            if (source.getClass().equals(LinkedHashMap.class)) {
                return ConversionUtils.convertMapToList((LinkedHashMap)source);
            }
            if (source.getClass().isArray()) {
                return ConversionUtils.convertArrayToList((Object[])source);
            }
        }
        if (target.equals(Set.class) && source.getClass().isArray()) {
            return ConversionUtils.convertArrayToSet((Object[])source);
        }
        throw new ConversionException("Unable to preform conversion");
    }

    public static Object convertToArray(Object source, Class<?> target) throws ConversionException {
        try {
            Object[] targetInstance = (Object[])Array.newInstance(target.getComponentType(), 0);
            if (source.getClass().isArray()) {
                Object[] sourceArray = (Object[])source;
                Class<?> targetType = target.getComponentType();
                ArrayList<Object> list = new ArrayList<Object>(sourceArray.length);
                for (Object element : sourceArray) {
                    list.add(ConversionUtils.convert(element, targetType));
                }
                source = list;
            }
            if (source instanceof Collection) {
                return ((Collection)source).toArray(targetInstance);
            }
            throw new ConversionException("Unable to convert to array");
        }
        catch (Exception ex) {
            throw new ConversionException("Error converting to array", (Throwable)ex);
        }
    }

    public static List<Object> convertMapToList(Map<?, ?> map) {
        ArrayList<Object> list = new ArrayList<Object>(map.size());
        list.addAll(map.values());
        return list;
    }

    public static Object convertToWrappedPrimitive(Object source, Class<?> wrapper) {
        if (source == null || wrapper == null) {
            return null;
        }
        if (wrapper.isInstance(source)) {
            return source;
        }
        if (wrapper.isAssignableFrom(source.getClass())) {
            return source;
        }
        if (source instanceof Number) {
            return ConversionUtils.convertNumberToWrapper((Number)source, wrapper);
        }
        return ConversionUtils.convertStringToWrapper(source.toString(), wrapper);
    }

    public static Object convertStringToWrapper(String str, Class<?> wrapper) {
        if (wrapper.equals(String.class)) {
            return str;
        }
        if (wrapper.equals(Boolean.class)) {
            return new Boolean(str);
        }
        if (wrapper.equals(Double.class)) {
            return new Double(str);
        }
        if (wrapper.equals(Long.class)) {
            return new Long(str);
        }
        if (wrapper.equals(Float.class)) {
            return new Float(str);
        }
        if (wrapper.equals(Integer.class)) {
            return new Integer(str);
        }
        if (wrapper.equals(Short.class)) {
            return new Short(str);
        }
        if (wrapper.equals(Byte.class)) {
            return new Byte(str);
        }
        throw new ConversionException("Unable to convert string to: " + wrapper);
    }

    public static Object convertNumberToWrapper(Number num, Class<?> wrapper) {
        if (wrapper.equals(String.class)) {
            return num.toString();
        }
        if (wrapper.equals(Boolean.class)) {
            return num.intValue() == 1;
        }
        if (wrapper.equals(Double.class)) {
            return num.doubleValue();
        }
        if (wrapper.equals(Long.class)) {
            return num.longValue();
        }
        if (wrapper.equals(Float.class)) {
            return Float.valueOf(num.floatValue());
        }
        if (wrapper.equals(Integer.class)) {
            return num.intValue();
        }
        if (wrapper.equals(Short.class)) {
            return num.shortValue();
        }
        if (wrapper.equals(Byte.class)) {
            return num.byteValue();
        }
        throw new ConversionException("Unable to convert number to: " + wrapper);
    }

    public static List<Method> findMethodsByNameAndNumParams(Object object, String method, int numParam) {
        Method[] methods;
        LinkedList<Method> list = new LinkedList<Method>();
        for (Method m : methods = object.getClass().getMethods()) {
            if (log.isDebugEnabled()) {
                log.debug("Method name: " + m.getName());
            }
            if (!m.getName().equals(method)) {
                log.debug("Method name not the same");
                continue;
            }
            if (m.getParameterTypes().length != numParam) {
                log.debug("Param length not the same");
                continue;
            }
            list.add(m);
        }
        return list;
    }

    public static Object[] convertParams(Object[] source, Class<?>[] target) throws ConversionException {
        Object[] converted = new Object[target.length];
        for (int i = 0; i < target.length; ++i) {
            converted[i] = ConversionUtils.convert(source[i], target[i]);
        }
        return converted;
    }

    public static List<?> convertArrayToList(Object[] source) throws ConversionException {
        ArrayList<Object> list = new ArrayList<Object>(source.length);
        for (Object element : source) {
            list.add(element);
        }
        return list;
    }

    public static Object convertMapToBean(Map<?, ?> source, Class<?> target) throws ConversionException {
        Object bean = ConversionUtils.newInstance(target.getClass().getName());
        if (bean == null) {
            throw new ConversionException("Unable to create bean using empty constructor");
        }
        try {
            BeanUtils.populate((Object)bean, source);
        }
        catch (Exception e) {
            throw new ConversionException("Error populating bean", (Throwable)e);
        }
        return bean;
    }

    public static Map<?, ?> convertBeanToMap(Object source) {
        return new BeanMap(source);
    }

    public static Set<?> convertArrayToSet(Object[] source) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object element : source) {
            set.add(element);
        }
        return set;
    }

    protected static Object newInstance(String className) {
        Object instance = null;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            instance = clazz.newInstance();
        }
        catch (Exception ex) {
            log.error("Error loading class: " + className, (Throwable)ex);
        }
        return instance;
    }

    static {
        for (int i = 0; i < PRIMITIVES.length; ++i) {
            primitiveMap.put(PRIMITIVES[i], WRAPPERS[i]);
            wrapperMap.put(WRAPPERS[i], PRIMITIVES[i]);
            parameterMap.put(WRAPPERS[i], PARAMETER_CHAINS[i]);
        }
    }
}

