/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.red5.annotations.DeclarePrivate;
import org.red5.annotations.DeclareProtected;
import org.red5.server.api.IConnection;
import org.red5.server.api.IScope;
import org.red5.server.api.Red5;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.service.IServiceInvoker;
import org.red5.server.exception.ClientDetailsException;
import org.red5.server.service.IServiceResolver;
import org.red5.server.service.MethodNotFoundException;
import org.red5.server.service.NotAllowedException;
import org.red5.server.service.ServiceNotFoundException;
import org.red5.server.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceInvoker
implements IServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(ServiceInvoker.class);
    public static final String SERVICE_NAME = "serviceInvoker";
    private Set<IServiceResolver> serviceResolvers = new HashSet<IServiceResolver>();

    public void setServiceResolvers(Set<IServiceResolver> resolvers) {
        this.serviceResolvers = resolvers;
    }

    private Object getServiceHandler(IScope scope, String serviceName) {
        Object service = scope.getHandler();
        if (serviceName == null || serviceName.equals("")) {
            return service;
        }
        for (IServiceResolver resolver : this.serviceResolvers) {
            service = resolver.resolveService(scope, serviceName);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    @Override
    public boolean invoke(IServiceCall call, IScope scope) {
        Object service;
        String serviceName = call.getServiceName();
        if (log.isDebugEnabled()) {
            log.debug("Service name " + serviceName);
        }
        if ((service = this.getServiceHandler(scope, serviceName)) == null) {
            call.setException(new ServiceNotFoundException(serviceName));
            call.setStatus((byte)16);
            log.warn("Service not found: " + serviceName);
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Service found: " + serviceName);
        }
        return this.invoke(call, service);
    }

    @Override
    public boolean invoke(IServiceCall call, Object service) {
        Object[] argsWithConnection;
        IConnection conn = Red5.getConnectionLocal();
        String methodName = call.getServiceMethodName();
        Object[] args = call.getArguments();
        if (args != null) {
            argsWithConnection = new Object[args.length + 1];
            argsWithConnection[0] = conn;
            for (int i = 0; i < args.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("   " + i + " => " + args[i]);
                }
                argsWithConnection[i + 1] = args[i];
            }
        } else {
            argsWithConnection = new Object[]{conn};
        }
        Object[] methodResult = null;
        methodResult = ServiceUtils.findMethodWithExactParameters(service, methodName, argsWithConnection);
        if (!(methodResult.length != 0 && methodResult[0] != null || (methodResult = ServiceUtils.findMethodWithExactParameters(service, methodName, args)).length != 0 && methodResult[0] != null || (methodResult = ServiceUtils.findMethodWithListParameters(service, methodName, argsWithConnection)).length != 0 && methodResult[0] != null || (methodResult = ServiceUtils.findMethodWithListParameters(service, methodName, args)).length != 0 && methodResult[0] != null)) {
            if (log.isDebugEnabled()) {
                log.error("Method " + methodName + " with parameters " + (args == null ? Collections.EMPTY_LIST : Arrays.asList(args)) + " not found in " + service);
            }
            call.setStatus((byte)17);
            if (args != null && args.length > 0) {
                call.setException(new MethodNotFoundException(methodName, args));
            } else {
                call.setException(new MethodNotFoundException(methodName));
            }
            return false;
        }
        Object result = null;
        Method method = (Method)methodResult[0];
        Object[] params = (Object[])methodResult[1];
        try {
            if (method.isAnnotationPresent(DeclarePrivate.class)) {
                if (log.isDebugEnabled()) {
                    log.debug("Method " + method + " is declared private.");
                }
                throw new NotAllowedException("you are not allowed to execute this method");
            }
            DeclareProtected annotation = method.getAnnotation(DeclareProtected.class);
            if (annotation != null && !conn.getClient().hasPermission(conn, annotation.permission())) {
                if (log.isDebugEnabled()) {
                    log.debug("Client " + conn.getClient() + " doesn't have required permission " + annotation.permission() + " to call " + method);
                }
                throw new NotAllowedException("you are not allowed to execute this method");
            }
            if (log.isDebugEnabled()) {
                log.debug("Invoking method: " + method.toString());
            }
            if (method.getReturnType() == Void.class) {
                method.invoke(service, params);
                call.setStatus((byte)4);
            } else {
                result = method.invoke(service, params);
                if (log.isDebugEnabled()) {
                    log.debug("result: " + result);
                }
                call.setStatus(result == null ? (byte)3 : 2);
            }
            if (call instanceof IPendingServiceCall) {
                ((IPendingServiceCall)call).setResult(result);
            }
        }
        catch (NotAllowedException e) {
            call.setException(e);
            call.setStatus((byte)18);
            return false;
        }
        catch (IllegalAccessException accessEx) {
            call.setException(accessEx);
            call.setStatus((byte)18);
            log.error("Error executing call: " + call);
            log.error("Service invocation error", (Throwable)accessEx);
            return false;
        }
        catch (InvocationTargetException invocationEx) {
            call.setException(invocationEx);
            call.setStatus((byte)19);
            if (!(invocationEx.getCause() instanceof ClientDetailsException)) {
                log.error("Error executing call: " + call);
                log.error("Service invocation error", (Throwable)invocationEx);
            }
            return false;
        }
        catch (Exception ex) {
            call.setException(ex);
            call.setStatus((byte)20);
            log.error("Error executing call: " + call);
            log.error("Service invocation error", (Throwable)ex);
            return false;
        }
        return true;
    }
}

