/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.so;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantLock;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.IConnection;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventDispatcher;
import org.red5.server.api.event.IEventListener;
import org.red5.server.api.so.IClientSharedObject;
import org.red5.server.api.so.ISharedObjectListener;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.ISharedObjectMessage;
import org.red5.server.so.SharedObject;
import org.red5.server.so.SharedObjectEvent;
import org.red5.server.so.SharedObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSharedObject
extends SharedObject
implements IClientSharedObject,
IEventDispatcher {
    protected static Logger log = LoggerFactory.getLogger(ClientSharedObject.class);
    private boolean initialSyncReceived;
    private final ReentrantLock lock = new ReentrantLock();
    private Set<ISharedObjectListener> listeners = new CopyOnWriteArraySet<ISharedObjectListener>();
    private Map<String, Object> handlers = new ConcurrentHashMap<String, Object>();

    public ClientSharedObject(String name, boolean persistent) {
        this.name = name;
        this.persistentSO = persistent;
    }

    @Override
    public void connect(IConnection conn) {
        if (!(conn instanceof RTMPConnection)) {
            throw new RuntimeException("can only connect through RTMP connections");
        }
        if (this.isConnected()) {
            throw new RuntimeException("already connected");
        }
        this.source = conn;
        SharedObjectMessage msg = new SharedObjectMessage(this.name, 0, this.isPersistentObject());
        msg.addEvent(new SharedObjectEvent(ISharedObjectEvent.Type.SERVER_CONNECT, null, null));
        Channel c = ((RTMPConnection)conn).getChannel(3);
        c.write(msg);
    }

    @Override
    public void disconnect() {
        SharedObjectMessage msg = new SharedObjectMessage(this.name, 0, this.isPersistentObject());
        msg.addEvent(new SharedObjectEvent(ISharedObjectEvent.Type.SERVER_DISCONNECT, null, null));
        Channel c = ((RTMPConnection)this.source).getChannel(3);
        c.write(msg);
        this.notifyDisconnect();
        this.initialSyncReceived = false;
    }

    @Override
    public boolean isConnected() {
        return this.initialSyncReceived;
    }

    @Override
    public void addSharedObjectListener(ISharedObjectListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSharedObjectListener(ISharedObjectListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(IEvent e) {
        if (e.getType() != IEvent.Type.SHARED_OBJECT || !(e instanceof ISharedObjectMessage)) {
            return;
        }
        ISharedObjectMessage msg = (ISharedObjectMessage)e;
        if (msg.hasSource()) {
            this.beginUpdate(msg.getSource());
        } else {
            this.beginUpdate();
        }
        try {
            block11: for (ISharedObjectEvent event : msg.getEvents()) {
                switch (event.getType()) {
                    case CLIENT_INITIAL_DATA: {
                        this.initialSyncReceived = true;
                        this.notifyConnect();
                        continue block11;
                    }
                    case CLIENT_CLEAR_DATA: {
                        this.attributes.clear();
                        this.notifyClear();
                        continue block11;
                    }
                    case CLIENT_DELETE_DATA: 
                    case CLIENT_DELETE_ATTRIBUTE: {
                        this.attributes.remove(event.getKey());
                        this.notifyDelete(event.getKey());
                        continue block11;
                    }
                    case CLIENT_SEND_MESSAGE: {
                        this.notifySendMessage(event.getKey(), (List)event.getValue());
                        continue block11;
                    }
                    case CLIENT_UPDATE_DATA: {
                        this.attributes.putAll((Map)event.getValue());
                        this.notifyUpdate(event.getKey(), (Map)event.getValue());
                        continue block11;
                    }
                    case CLIENT_UPDATE_ATTRIBUTE: {
                        this.attributes.put(event.getKey(), event.getValue());
                        this.notifyUpdate(event.getKey(), event.getValue());
                        continue block11;
                    }
                }
                log.warn("Unknown SO event: " + (Object)((Object)event.getType()));
            }
        }
        finally {
            this.endUpdate();
        }
    }

    protected void notifyConnect() {
        for (ISharedObjectListener listener : this.listeners) {
            listener.onSharedObjectConnect(this);
        }
    }

    protected void notifyDisconnect() {
        for (ISharedObjectListener listener : this.listeners) {
            listener.onSharedObjectDisconnect(this);
        }
    }

    protected void notifyUpdate(String key, Object value) {
        for (ISharedObjectListener listener : this.listeners) {
            listener.onSharedObjectUpdate(this, key, value);
        }
    }

    protected void notifyUpdate(String key, Map<String, Object> value) {
        if (value.size() == 1) {
            Map.Entry<String, Object> entry = value.entrySet().iterator().next();
            this.notifyUpdate(entry.getKey(), entry.getValue());
            return;
        }
        for (ISharedObjectListener listener : this.listeners) {
            listener.onSharedObjectUpdate(this, key, value);
        }
    }

    protected void notifyDelete(String key) {
        for (ISharedObjectListener listener : this.listeners) {
            listener.onSharedObjectDelete(this, key);
        }
    }

    protected void notifyClear() {
        for (ISharedObjectListener listener : this.listeners) {
            listener.onSharedObjectClear(this);
        }
    }

    protected void notifySendMessage(String method, List<?> params) {
        for (ISharedObjectListener listener : this.listeners) {
            listener.onSharedObjectSend(this, method, params);
        }
    }

    @Override
    public synchronized boolean setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        this.ownerMessage.addEvent(ISharedObjectEvent.Type.SERVER_SET_ATTRIBUTE, name, value);
        this.notifyModified();
        return true;
    }

    @Override
    public synchronized void setAttributes(IAttributeStore values) {
        this.setAttributes(values.getAttributes());
    }

    @Override
    public synchronized void setAttributes(Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized boolean removeAttribute(String name) {
        this.ownerMessage.addEvent(ISharedObjectEvent.Type.SERVER_DELETE_ATTRIBUTE, name, null);
        this.notifyModified();
        return true;
    }

    @Override
    public synchronized void sendMessage(String handler, List arguments) {
        this.ownerMessage.addEvent(ISharedObjectEvent.Type.SERVER_SEND_MESSAGE, handler, arguments);
        this.notifyModified();
    }

    @Override
    public synchronized void removeAttributes() {
        for (String key : this.getAttributeNames()) {
            this.ownerMessage.addEvent(ISharedObjectEvent.Type.SERVER_DELETE_ATTRIBUTE, key, null);
        }
        this.notifyModified();
    }

    @Override
    public synchronized boolean clear() {
        return super.clear();
    }

    @Override
    public synchronized void close() {
        super.close();
    }

    @Override
    public void beginUpdate() {
        this.lock.lock();
        super.beginUpdate();
    }

    @Override
    public void beginUpdate(IEventListener listener) {
        this.lock.lock();
        super.beginUpdate(listener);
    }

    @Override
    public void endUpdate() {
        super.endUpdate();
        this.lock.unlock();
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public boolean isLocked() {
        return this.lock.isLocked();
    }

    @Override
    public void registerServiceHandler(Object handler) {
        this.registerServiceHandler("", handler);
    }

    @Override
    public void unregisterServiceHandler(String name) {
        this.handlers.remove(name);
    }

    @Override
    public void registerServiceHandler(String name, Object handler) {
        if (name == null) {
            name = "";
        }
        this.handlers.put(name, handler);
    }

    @Override
    public Object getServiceHandler(String name) {
        if (name == null) {
            name = "";
        }
        return this.handlers.get(name);
    }

    @Override
    public Set<String> getServiceHandlerNames() {
        return Collections.unmodifiableSet(this.handlers.keySet());
    }

    @Override
    public synchronized Object getAttribute(String name, Object defaultValue) {
        if (!this.hasAttribute(name)) {
            this.setAttribute(name, defaultValue);
        }
        return this.getAttribute(name);
    }
}

