/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.so;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.red5.server.api.IScope;
import org.red5.server.api.persistence.IPersistenceStore;
import org.red5.server.api.persistence.PersistenceUtils;
import org.red5.server.api.so.ISharedObject;
import org.red5.server.api.so.ISharedObjectService;
import org.red5.server.persistence.RamPersistence;
import org.red5.server.so.SharedObjectScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedObjectService
implements ISharedObjectService {
    private Logger log = LoggerFactory.getLogger(SharedObjectService.class);
    private static final String SO_PERSISTENCE_STORE = "_transient_SO_PERSISTENCE_STORE_";
    private static final String SO_TRANSIENT_STORE = "_transient_SO_TRANSIENT_STORE_";
    private String persistenceClassName = "org.red5.server.persistence.RamPersistence";

    public void setPersistenceClassName(String name) {
        this.persistenceClassName = name;
    }

    private IPersistenceStore getStore(IScope scope, boolean persistent) {
        if (!persistent) {
            if (!scope.hasAttribute(SO_TRANSIENT_STORE)) {
                RamPersistence store = new RamPersistence(scope);
                scope.setAttribute(SO_TRANSIENT_STORE, store);
                return store;
            }
            return (IPersistenceStore)scope.getAttribute(SO_TRANSIENT_STORE);
        }
        if (!scope.hasAttribute(SO_PERSISTENCE_STORE)) {
            IPersistenceStore store;
            try {
                store = PersistenceUtils.getPersistenceStore(scope, this.persistenceClassName);
                this.log.info("Created persistence store " + store + " for shared objects.");
            }
            catch (Exception err) {
                this.log.error("Could not create persistence store for shared objects, falling back to Ram persistence.", (Throwable)err);
                store = new RamPersistence(scope);
            }
            scope.setAttribute(SO_PERSISTENCE_STORE, store);
            return store;
        }
        return (IPersistenceStore)scope.getAttribute(SO_PERSISTENCE_STORE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createSharedObject(IScope scope, String name, boolean persistent) {
        IScope iScope = scope;
        synchronized (iScope) {
            if (this.hasSharedObject(scope, name)) {
                return true;
            }
            SharedObjectScope soScope = new SharedObjectScope(scope, name, persistent, this.getStore(scope, persistent));
            return scope.addChildScope(soScope);
        }
    }

    @Override
    public ISharedObject getSharedObject(IScope scope, String name) {
        return (ISharedObject)scope.getBasicScope("SharedObject", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISharedObject getSharedObject(IScope scope, String name, boolean persistent) {
        IScope iScope = scope;
        synchronized (iScope) {
            if (!this.hasSharedObject(scope, name)) {
                this.createSharedObject(scope, name, persistent);
            }
            return this.getSharedObject(scope, name);
        }
    }

    @Override
    public Set<String> getSharedObjectNames(IScope scope) {
        HashSet<String> result = new HashSet<String>();
        Iterator<String> iter = scope.getBasicScopeNames("SharedObject");
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    @Override
    public boolean hasSharedObject(IScope scope, String name) {
        return scope.hasChildScope("SharedObject", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearSharedObjects(IScope scope, String name) {
        boolean result = false;
        IScope iScope = scope;
        synchronized (iScope) {
            if (this.hasSharedObject(scope, name)) {
                result = ((ISharedObject)scope.getBasicScope("SharedObject", name)).clear();
            }
        }
        return result;
    }
}

