/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.statistics;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.red5.server.api.IScope;
import org.red5.server.api.ScopeUtils;
import org.red5.server.api.so.ISharedObject;
import org.red5.server.api.so.ISharedObjectService;
import org.red5.server.exception.ScopeNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcScopeStatistics {
    private IScope globalScope;

    public XmlRpcScopeStatistics() {
    }

    public XmlRpcScopeStatistics(IScope globalScope) {
        this.globalScope = globalScope;
    }

    public void setGlobalScope(IScope scope) {
        this.globalScope = scope;
    }

    private IScope getScope(String path) throws ScopeNotFoundException {
        IScope scope = path != null && !path.equals("") ? ScopeUtils.resolveScope(this.globalScope, path) : this.globalScope;
        if (scope == null) {
            throw new ScopeNotFoundException(this.globalScope, path);
        }
        return scope;
    }

    public String[] getScopes() {
        return this.getScopes(null);
    }

    public String[] getScopes(String path) {
        IScope scope = this.getScope(path);
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> iter = scope.getScopeNames();
        while (iter.hasNext()) {
            String name = iter.next();
            result.add(name.substring(name.indexOf(":") + 1));
        }
        return result.toArray(new String[result.size()]);
    }

    public Map<String, Object> getScopeAttributes() {
        return this.getScopeAttributes(null);
    }

    private Object getXMLRPCValue(Object value) {
        if (value == null) {
            return "<null>";
        }
        Class<?> type = value.getClass();
        if (type.equals(Integer.class) || type.equals(Double.class) || type.equals(Boolean.class) || type.equals(String.class) || type.equals(Date.class)) {
            return value;
        }
        if (type.equals(Long.class)) {
            return ((Long)value).toString();
        }
        if (type.isArray() && type.getComponentType().equals(Byte.TYPE)) {
            return value;
        }
        if (type.isArray()) {
            int length = Array.getLength(value);
            Vector<Object> res = new Vector<Object>();
            for (int i = 0; i < length; ++i) {
                res.add(this.getXMLRPCValue(Array.get(value, i)));
            }
            return res;
        }
        if (value instanceof Map) {
            Hashtable res = new Hashtable();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                res.put(entry.getKey(), this.getXMLRPCValue(entry.getValue()));
            }
            return res;
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            Vector<Object> result = new Vector<Object>(coll.size());
            for (Object item : coll) {
                result.add(this.getXMLRPCValue(item));
            }
            return result;
        }
        throw new RuntimeException("Don't know how to convert " + value);
    }

    public Map<String, Object> getScopeAttributes(String path) {
        IScope scope = this.getScope(path);
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        for (String name : scope.getAttributeNames()) {
            Object value = scope.getAttribute(name);
            try {
                result.put(name, this.getXMLRPCValue(value));
            }
            catch (RuntimeException err) {}
        }
        return result;
    }

    public Map<String, Object> getSharedObjects(String path) {
        IScope scope = this.getScope(path);
        ISharedObjectService service = (ISharedObjectService)ScopeUtils.getScopeService(scope, ISharedObjectService.class, false);
        if (service == null) {
            return new Hashtable<String, Object>();
        }
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        for (String name : service.getSharedObjectNames(scope)) {
            ISharedObject so = service.getSharedObject(scope, name);
            try {
                result.put(name, new Object[]{so.isPersistentObject(), this.getXMLRPCValue(so.getData())});
            }
            catch (RuntimeException err) {
                result.put(name, "--- Error while serializing \"" + so.getData().toString() + "\" ---");
            }
        }
        return result;
    }
}

