/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import org.red5.server.api.IScope;
import org.red5.server.api.ScopeUtils;
import org.red5.server.api.stream.IStreamFilenameGenerator;

public class DefaultStreamFilenameGenerator
implements IStreamFilenameGenerator {
    private String getStreamDirectory(IScope scope) {
        StringBuilder result = new StringBuilder();
        IScope app = ScopeUtils.findApplication(scope);
        String prefix = "streams/";
        while (scope != null && scope != app) {
            result.insert(0, scope.getName() + "/");
            scope = scope.getParent();
        }
        if (result.length() == 0) {
            return "streams/";
        }
        result.insert(0, "streams/").append("/");
        return result.toString();
    }

    public String generateFilename(IScope scope, String name, IStreamFilenameGenerator.GenerationType type) {
        return this.generateFilename(scope, name, null, type);
    }

    public String generateFilename(IScope scope, String name, String extension, IStreamFilenameGenerator.GenerationType type) {
        String result = this.getStreamDirectory(scope) + name;
        if (extension != null && !extension.equals("")) {
            result = result + extension;
        }
        return result;
    }

    public boolean resolvesToAbsolutePath() {
        return false;
    }
}

