/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import org.red5.io.ITag;
import org.red5.io.ITagReader;
import org.red5.io.flv.IKeyFrameDataAnalyzer;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Unknown;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.stream.ISeekableStreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStreamSource
implements ISeekableStreamSource,
Constants {
    protected static Logger log = LoggerFactory.getLogger((String)FileStreamSource.class.getName());
    private ITagReader reader;
    private IKeyFrameDataAnalyzer.KeyFrameMeta keyFrameMeta;

    public FileStreamSource(ITagReader reader) {
        this.reader = reader;
    }

    public void close() {
        this.reader.close();
    }

    public IRTMPEvent dequeue() {
        BaseEvent msg;
        if (!this.reader.hasMoreTags()) {
            return null;
        }
        ITag tag = this.reader.readTag();
        switch (tag.getDataType()) {
            case 8: {
                msg = new AudioData(tag.getBody());
                break;
            }
            case 9: {
                msg = new VideoData(tag.getBody());
                break;
            }
            case 20: {
                msg = new Invoke(tag.getBody());
                break;
            }
            case 18: {
                msg = new Notify(tag.getBody());
                break;
            }
            default: {
                log.warn("Unexpected type? " + tag.getDataType());
                msg = new Unknown(tag.getDataType(), tag.getBody());
            }
        }
        msg.setTimestamp(tag.getTimestamp());
        return msg;
    }

    public boolean hasMore() {
        return this.reader.hasMoreTags();
    }

    public synchronized int seek(int ts) {
        if (this.keyFrameMeta == null) {
            if (!(this.reader instanceof IKeyFrameDataAnalyzer)) {
                return ts;
            }
            this.keyFrameMeta = ((IKeyFrameDataAnalyzer)((Object)this.reader)).analyzeKeyFrames();
        }
        if (this.keyFrameMeta.positions.length == 0) {
            return ts;
        }
        int frame = 0;
        int i = 0;
        while (i < this.keyFrameMeta.positions.length && this.keyFrameMeta.timestamps[i] <= ts) {
            frame = i++;
        }
        this.reader.position(this.keyFrameMeta.positions[frame]);
        return this.keyFrameMeta.timestamps[frame];
    }
}

