/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.amf.Output;
import org.red5.io.object.Serializer;
import org.red5.server.api.IBandwidthConfigure;
import org.red5.server.api.IContext;
import org.red5.server.api.IScope;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.statistics.IPlaylistSubscriberStreamStatistics;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IPlayItem;
import org.red5.server.api.stream.IPlaylistController;
import org.red5.server.api.stream.IPlaylistSubscriberStream;
import org.red5.server.api.stream.IStreamAwareScopeHandler;
import org.red5.server.api.stream.IVideoStreamCodec;
import org.red5.server.api.stream.OperationNotSupportedException;
import org.red5.server.messaging.AbstractMessage;
import org.red5.server.messaging.IFilter;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IMessageInput;
import org.red5.server.messaging.IMessageOutput;
import org.red5.server.messaging.IPassive;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.IPushableConsumer;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.status.Status;
import org.red5.server.stream.AbstractClientStream;
import org.red5.server.stream.IBWControlContext;
import org.red5.server.stream.IBWControlService;
import org.red5.server.stream.IBroadcastScope;
import org.red5.server.stream.IConsumerService;
import org.red5.server.stream.IFrameDropper;
import org.red5.server.stream.IProviderService;
import org.red5.server.stream.ISeekableProvider;
import org.red5.server.stream.IStreamData;
import org.red5.server.stream.IStreamTypeAwareProvider;
import org.red5.server.stream.ITokenBucket;
import org.red5.server.stream.SimplePlaylistController;
import org.red5.server.stream.VideoFrameDropper;
import org.red5.server.stream.message.RTMPMessage;
import org.red5.server.stream.message.ResetMessage;
import org.red5.server.stream.message.StatusMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistSubscriberStream
extends AbstractClientStream
implements IPlaylistSubscriberStream,
IPlaylistSubscriberStreamStatistics {
    private static final Logger log = LoggerFactory.getLogger(PlaylistSubscriberStream.class);
    private IPlaylistController controller;
    private IPlaylistController defaultController = new SimplePlaylistController();
    private final List<IPlayItem> items = new ArrayList<IPlayItem>();
    private int currentItemIndex = 0;
    private PlayEngine engine = new PlayEngine();
    private IBWControlService bwController;
    private IBWControlContext bwContext;
    private boolean isRewind;
    private boolean isRandom;
    private boolean isRepeat;
    private boolean receiveVideo = true;
    private boolean receiveAudio = true;
    private static ScheduledThreadPoolExecutor executor;
    private int bufferCheckInterval = 0;
    private int underrunTrigger = 10;
    private long creationTime = System.currentTimeMillis();
    private long bytesSent = 0L;

    public void setExecutor(ScheduledThreadPoolExecutor executor) {
        PlaylistSubscriberStream.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledThreadPoolExecutor getExecutor() {
        if (executor == null) {
            PlaylistSubscriberStream playlistSubscriberStream = this;
            synchronized (playlistSubscriberStream) {
                if (executor == null) {
                    executor = new ScheduledThreadPoolExecutor(16);
                }
            }
        }
        return executor;
    }

    public void setBufferCheckInterval(int bufferCheckInterval) {
        this.bufferCheckInterval = bufferCheckInterval;
    }

    public void setUnderrunTrigger(int underrunTrigger) {
        this.underrunTrigger = underrunTrigger;
    }

    public void start() {
        this.bwController = (IBWControlService)this.getScope().getContext().getBean("BWControlService");
        this.bwContext = this.bwController.registerBWControllable(this);
        this.engine.start();
        this.notifySubscriberStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() throws IOException {
        List<IPlayItem> list = this.items;
        synchronized (list) {
            if (this.items.size() == 0) {
                return;
            }
            if (this.currentItemIndex == -1) {
                this.moveToNext();
            }
            IPlayItem item = this.items.get(this.currentItemIndex);
            int count = this.items.size();
            while (count-- > 0) {
                try {
                    this.engine.play(item);
                    break;
                }
                catch (StreamNotFoundException e) {
                    this.moveToNext();
                    if (this.currentItemIndex == -1) break;
                    item = this.items.get(this.currentItemIndex);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    public void pause(int position) {
        try {
            this.engine.pause(position);
        }
        catch (IllegalStateException e) {
            log.debug("pause caught an IllegalStateException");
        }
    }

    public void resume(int position) {
        try {
            this.engine.resume(position);
        }
        catch (IllegalStateException e) {
            log.debug("resume caught an IllegalStateException");
        }
    }

    public void stop() {
        try {
            this.engine.stop();
        }
        catch (IllegalStateException e) {
            log.debug("stop caught an IllegalStateException");
        }
    }

    public void seek(int position) throws OperationNotSupportedException {
        try {
            this.engine.seek(position);
        }
        catch (IllegalStateException e) {
            log.debug("seek caught an IllegalStateException");
        }
    }

    public void close() {
        this.engine.close();
        this.bwController.unregisterBWControllable(this.bwContext);
        this.notifySubscriberClose();
    }

    public boolean isPaused() {
        return this.engine.state == State.PAUSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(IPlayItem item) {
        List<IPlayItem> list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(IPlayItem item, int index) {
        List<IPlayItem> list = this.items;
        synchronized (list) {
            this.items.add(index, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(int index) {
        List<IPlayItem> list = this.items;
        synchronized (list) {
            if (index < 0 || index >= this.items.size()) {
                return;
            }
            int originSize = this.items.size();
            this.items.remove(index);
            if (this.currentItemIndex == index && index == originSize - 1) {
                this.currentItemIndex = index - 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllItems() {
        List<IPlayItem> list = this.items;
        synchronized (list) {
            this.stop();
            this.items.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void previousItem() {
        List<IPlayItem> list = this.items;
        synchronized (list) {
            this.stop();
            this.moveToPrevious();
            if (this.currentItemIndex == -1) {
                return;
            }
            IPlayItem item = this.items.get(this.currentItemIndex);
            int count = this.items.size();
            while (count-- > 0) {
                try {
                    this.engine.play(item);
                    break;
                }
                catch (IOException err) {
                    log.error("Error while starting to play item, moving to next.", (Throwable)err);
                    this.moveToPrevious();
                    if (this.currentItemIndex == -1) break;
                    item = this.items.get(this.currentItemIndex);
                }
                catch (StreamNotFoundException e) {
                    this.moveToPrevious();
                    if (this.currentItemIndex == -1) break;
                    item = this.items.get(this.currentItemIndex);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreItems() {
        List<IPlayItem> list = this.items;
        synchronized (list) {
            int nextItem = this.currentItemIndex + 1;
            return nextItem < this.items.size() || this.isRepeat;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextItem() {
        List<IPlayItem> list = this.items;
        synchronized (list) {
            this.moveToNext();
            if (this.currentItemIndex == -1) {
                return;
            }
            IPlayItem item = this.items.get(this.currentItemIndex);
            int count = this.items.size();
            while (count-- > 0) {
                try {
                    this.engine.play(item, false);
                    break;
                }
                catch (IOException err) {
                    log.error("Error while starting to play item, moving to next.", (Throwable)err);
                    this.moveToNext();
                    if (this.currentItemIndex == -1) break;
                    item = this.items.get(this.currentItemIndex);
                }
                catch (StreamNotFoundException e) {
                    this.moveToNext();
                    if (this.currentItemIndex == -1) break;
                    item = this.items.get(this.currentItemIndex);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItem(int index) {
        List<IPlayItem> list = this.items;
        synchronized (list) {
            if (index < 0 || index >= this.items.size()) {
                return;
            }
            this.stop();
            this.currentItemIndex = index;
            IPlayItem item = this.items.get(this.currentItemIndex);
            try {
                this.engine.play(item);
            }
            catch (IOException e) {
                log.error("setItem caught a IOException", (Throwable)e);
            }
            catch (StreamNotFoundException e) {
                log.debug("setItem caught a StreamNotFoundException");
            }
            catch (IllegalStateException e) {
                log.error("Illegal state exception on playlist item setup", (Throwable)e);
            }
        }
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public void setRandom(boolean random) {
        this.isRandom = random;
    }

    public boolean isRewind() {
        return this.isRewind;
    }

    public void setRewind(boolean rewind) {
        this.isRewind = rewind;
    }

    public boolean isRepeat() {
        return this.isRepeat;
    }

    public void setRepeat(boolean repeat) {
        this.isRepeat = repeat;
    }

    private void seekToCurrentPlayback() {
        if (this.engine.isPullMode) {
            try {
                long delta = System.currentTimeMillis() - this.engine.playbackStart;
                this.engine.seek((int)delta);
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                // empty catch block
            }
        }
    }

    public void receiveVideo(boolean receive) {
        boolean seek = !this.receiveVideo && receive;
        this.receiveVideo = receive;
        if (seek) {
            this.seekToCurrentPlayback();
        }
    }

    public void receiveAudio(boolean receive) {
        if (this.receiveAudio && !receive) {
            this.engine.sendBlankAudio = true;
        }
        boolean seek = !this.receiveAudio && receive;
        this.receiveAudio = receive;
        if (seek) {
            this.seekToCurrentPlayback();
        }
    }

    public void setPlaylistController(IPlaylistController controller) {
        this.controller = controller;
    }

    public int getItemSize() {
        return this.items.size();
    }

    public int getCurrentItemIndex() {
        return this.currentItemIndex;
    }

    public IPlayItem getCurrentItem() {
        return this.getItem(this.getCurrentItemIndex());
    }

    public IPlayItem getItem(int index) {
        try {
            return this.items.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public void setBandwidthConfigure(IBandwidthConfigure config) {
        super.setBandwidthConfigure(config);
        this.engine.updateBandwithConfigure();
    }

    public void written(Object message) {
        if (!this.engine.isPullMode) {
            return;
        }
        try {
            this.engine.pullAndPush();
        }
        catch (Throwable err) {
            log.error("Error while pulling message.", err);
        }
    }

    private void moveToNext() {
        this.currentItemIndex = this.controller != null ? this.controller.nextItem(this, this.currentItemIndex) : this.defaultController.nextItem(this, this.currentItemIndex);
    }

    private void moveToPrevious() {
        this.currentItemIndex = this.controller != null ? this.controller.previousItem(this, this.currentItemIndex) : this.defaultController.previousItem(this, this.currentItemIndex);
    }

    private void onItemEnd() {
        this.nextItem();
    }

    private void notifySubscriberStart() {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamSubscriberStart(this);
            }
            catch (Throwable t) {
                log.error("error notify streamSubscriberStart", t);
            }
        }
    }

    private void notifySubscriberClose() {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamSubscriberClose(this);
            }
            catch (Throwable t) {
                log.error("error notify streamSubscriberClose", t);
            }
        }
    }

    private void notifyItemPlay(IPlayItem item, boolean isLive) {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamPlaylistItemPlay(this, item, isLive);
            }
            catch (Throwable t) {
                log.error("error notify streamPlaylistItemPlay", t);
            }
        }
    }

    private void notifyItemStop(IPlayItem item) {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamPlaylistItemStop(this, item);
            }
            catch (Throwable t) {
                log.error("error notify streamPlaylistItemStop", t);
            }
        }
    }

    private void notifyItemPause(IPlayItem item, int position) {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamPlaylistVODItemPause(this, item, position);
            }
            catch (Throwable t) {
                log.error("error notify streamPlaylistVODItemPause", t);
            }
        }
    }

    private void notifyItemResume(IPlayItem item, int position) {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamPlaylistVODItemResume(this, item, position);
            }
            catch (Throwable t) {
                log.error("error notify streamPlaylistVODItemResume", t);
            }
        }
    }

    private void notifyItemSeek(IPlayItem item, int position) {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamPlaylistVODItemSeek(this, item, position);
            }
            catch (Throwable t) {
                log.error("error notify streamPlaylistVODItemSeek", t);
            }
        }
    }

    public IPlaylistSubscriberStreamStatistics getStatistics() {
        return this;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getCurrentTimestamp() {
        IRTMPEvent msg = this.engine.lastMessage;
        if (msg == null) {
            return 0;
        }
        return msg.getTimestamp();
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public double getEstimatedBufferFill() {
        IRTMPEvent msg = this.engine.lastMessage;
        if (msg == null) {
            return 0.0;
        }
        long buffer = this.getClientBufferDuration();
        if (buffer == 0L) {
            return 100.0;
        }
        long delta = System.currentTimeMillis() - this.engine.playbackStart;
        long buffered = (long)msg.getTimestamp() - delta;
        return (double)buffered * 100.0 / (double)buffer;
    }

    private class StreamNotFoundException
    extends Exception {
        private static final long serialVersionUID = 812106823615971891L;

        public StreamNotFoundException(String name) {
            super("Stream " + name + " not found.");
        }
    }

    private class PlayEngine
    implements IFilter,
    IPushableConsumer,
    IPipeConnectionListener,
    ITokenBucket.ITokenBucketCallback {
        private State state;
        private IMessageInput msgIn;
        private IMessageOutput msgOut;
        private boolean isPullMode;
        private ISchedulingService schedulingService;
        private String waitLiveJob;
        private boolean isWaiting;
        private int vodStartTS;
        private IPlayItem currentItem;
        private ITokenBucket audioBucket;
        private ITokenBucket videoBucket;
        private RTMPMessage pendingMessage;
        private boolean isWaitingForToken = false;
        private boolean needCheckBandwidth = true;
        private IFrameDropper videoFrameDropper = new VideoFrameDropper();
        private int timestampOffset = 0;
        private IRTMPEvent lastMessage;
        private long bytesSent = 0L;
        private long playbackStart;
        private volatile ScheduledFuture<?> pullAndPushFuture = null;
        private int streamOffset;
        private long nextCheckBufferUnderrun;
        private boolean sendBlankAudio;

        public PlayEngine() {
            this.state = State.UNINIT;
        }

        public synchronized void start() {
            if (this.state != State.UNINIT) {
                throw new IllegalStateException();
            }
            this.state = State.STOPPED;
            this.schedulingService = (ISchedulingService)PlaylistSubscriberStream.this.getScope().getContext().getBean("schedulingService");
            IConsumerService consumerManager = (IConsumerService)PlaylistSubscriberStream.this.getScope().getContext().getBean("consumerService");
            this.msgOut = consumerManager.getConsumerOutput(PlaylistSubscriberStream.this);
            this.msgOut.subscribe(this, null);
            this.audioBucket = PlaylistSubscriberStream.this.bwController.getAudioBucket(PlaylistSubscriberStream.this.bwContext);
            this.videoBucket = PlaylistSubscriberStream.this.bwController.getVideoBucket(PlaylistSubscriberStream.this.bwContext);
        }

        public synchronized void play(IPlayItem item) throws StreamNotFoundException, IllegalStateException, IOException {
            this.play(item, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void play(IPlayItem item, boolean withReset) throws StreamNotFoundException, IllegalStateException, IOException {
            if (this.state != State.STOPPED) {
                throw new IllegalStateException();
            }
            if (this.msgIn != null) {
                this.msgIn.unsubscribe(this);
                this.msgIn = null;
            }
            int type = (int)(item.getStart() / 1000L);
            IScope thisScope = PlaylistSubscriberStream.this.getScope();
            IContext context = thisScope.getContext();
            IProviderService providerService = (IProviderService)context.getBean("providerService");
            IMessageInput liveInput = providerService.getLiveProviderInput(thisScope, item.getName(), false);
            IMessageInput vodInput = providerService.getVODProviderInput(thisScope, item.getName());
            boolean isPublishedStream = liveInput != null;
            boolean isFileStream = vodInput != null;
            boolean sendNotifications = true;
            int decision = 3;
            switch (type) {
                case -2: {
                    if (isPublishedStream) {
                        decision = 0;
                        break;
                    }
                    if (isFileStream) {
                        decision = 1;
                        break;
                    }
                    decision = 2;
                    break;
                }
                case -1: {
                    if (isPublishedStream) {
                        decision = 0;
                        break;
                    }
                    decision = 2;
                    break;
                }
                default: {
                    if (!isFileStream) break;
                    decision = 1;
                }
            }
            if (decision == 2) {
                liveInput = providerService.getLiveProviderInput(thisScope, item.getName(), true);
            }
            this.currentItem = item;
            switch (decision) {
                case 0: {
                    ByteBuffer keyFrame;
                    IVideoStreamCodec videoCodec;
                    IClientBroadcastStream stream;
                    this.msgIn = liveInput;
                    this.videoFrameDropper.reset(3);
                    if (this.msgIn instanceof IBroadcastScope && (stream = (IClientBroadcastStream)((IBroadcastScope)this.msgIn).getAttribute("_transient_publishing_stream")) != null && stream.getCodecInfo() != null && (videoCodec = stream.getCodecInfo().getVideoCodec()) != null && (keyFrame = videoCodec.getKeyframe()) != null) {
                        VideoData video = new VideoData(keyFrame);
                        try {
                            if (withReset) {
                                this.sendReset();
                                this.sendResetStatus(item);
                                this.sendStartStatus(item);
                            }
                            video.setTimestamp(0);
                            RTMPMessage videoMsg = new RTMPMessage();
                            videoMsg.setBody(video);
                            this.msgOut.pushMessage(videoMsg);
                            sendNotifications = false;
                            this.videoFrameDropper.reset();
                        }
                        finally {
                            video.release();
                        }
                    }
                    this.msgIn.subscribe(this, null);
                    break;
                }
                case 2: {
                    this.msgIn = liveInput;
                    this.msgIn.subscribe(this, null);
                    this.isWaiting = true;
                    if (type != -1 || item.getLength() < 0L) break;
                    this.waitLiveJob = this.schedulingService.addScheduledOnceJob(item.getLength(), new IScheduledJob(){

                        public void execute(ISchedulingService service) {
                            PlayEngine.this.waitLiveJob = null;
                            PlayEngine.this.isWaiting = false;
                            PlaylistSubscriberStream.this.onItemEnd();
                        }
                    });
                    break;
                }
                case 1: {
                    this.msgIn = vodInput;
                    this.msgIn.subscribe(this, null);
                    break;
                }
                default: {
                    this.sendStreamNotFoundStatus(this.currentItem);
                    throw new StreamNotFoundException(item.getName());
                }
            }
            this.state = State.PLAYING;
            IMessage msg = null;
            this.streamOffset = 0;
            if (decision == 1) {
                if (withReset) {
                    this.releasePendingMessage();
                }
                this.sendVODInitCM(this.msgIn, item);
                this.vodStartTS = -1;
                if (item.getStart() > 0L) {
                    this.streamOffset = this.sendVODSeekCM(this.msgIn, (int)item.getStart());
                    if (this.streamOffset == -1) {
                        this.streamOffset = (int)item.getStart();
                    }
                }
                if ((msg = this.msgIn.pullMessage()) instanceof RTMPMessage) {
                    IRTMPEvent body = ((RTMPMessage)msg).getBody();
                    if (item.getLength() == 0L) {
                        body = ((RTMPMessage)msg).getBody();
                        while (body != null && !(body instanceof VideoData) && (msg = this.msgIn.pullMessage()) != null) {
                            if (!(msg instanceof RTMPMessage)) continue;
                            body = ((RTMPMessage)msg).getBody();
                        }
                    }
                    if (body != null) {
                        body.setTimestamp(body.getTimestamp() + this.timestampOffset);
                    }
                }
            }
            if (sendNotifications) {
                if (withReset) {
                    this.sendReset();
                    this.sendResetStatus(item);
                }
                this.sendStartStatus(item);
                if (!withReset) {
                    this.sendSwitchStatus();
                }
            }
            if (msg != null) {
                this.sendMessage((RTMPMessage)msg);
            }
            PlaylistSubscriberStream.this.notifyItemPlay(this.currentItem, !this.isPullMode);
            if (withReset) {
                this.playbackStart = System.currentTimeMillis() - (long)this.streamOffset;
                this.nextCheckBufferUnderrun = System.currentTimeMillis() + (long)PlaylistSubscriberStream.this.bufferCheckInterval;
                if (this.currentItem.getLength() != 0L) {
                    this.ensurePullAndPushRunning();
                }
            }
        }

        public synchronized void pause(int position) throws IllegalStateException {
            if (this.state != State.PLAYING && this.state != State.STOPPED || this.currentItem == null) {
                throw new IllegalStateException();
            }
            this.state = State.PAUSED;
            this.releasePendingMessage();
            this.clearWaitJobs();
            this.sendClearPing();
            this.sendPauseStatus(this.currentItem);
            PlaylistSubscriberStream.this.notifyItemPause(this.currentItem, position);
        }

        public synchronized void resume(int position) throws IllegalStateException {
            if (this.state != State.PAUSED) {
                throw new IllegalStateException();
            }
            this.state = State.PLAYING;
            this.sendReset();
            this.sendResumeStatus(this.currentItem);
            if (this.isPullMode) {
                this.sendVODSeekCM(this.msgIn, position);
                PlaylistSubscriberStream.this.notifyItemResume(this.currentItem, position);
                this.playbackStart = System.currentTimeMillis() - (long)position;
                if (this.currentItem.getLength() >= 0L && (long)(position - this.streamOffset) >= this.currentItem.getLength()) {
                    this.stop();
                } else {
                    this.ensurePullAndPushRunning();
                }
            } else {
                PlaylistSubscriberStream.this.notifyItemResume(this.currentItem, position);
                this.videoFrameDropper.reset(3);
            }
        }

        public synchronized void seek(int position) throws IllegalStateException, OperationNotSupportedException {
            if (this.state != State.PLAYING && this.state != State.PAUSED && this.state != State.STOPPED) {
                throw new IllegalStateException();
            }
            if (!this.isPullMode) {
                throw new OperationNotSupportedException();
            }
            this.releasePendingMessage();
            this.clearWaitJobs();
            PlaylistSubscriberStream.this.bwController.resetBuckets(PlaylistSubscriberStream.this.bwContext);
            this.isWaitingForToken = false;
            this.sendClearPing();
            this.sendReset();
            this.sendSeekStatus(this.currentItem, position);
            this.sendStartStatus(this.currentItem);
            int seekPos = this.sendVODSeekCM(this.msgIn, position);
            if (seekPos == -1) {
                seekPos = position;
            }
            this.playbackStart = System.currentTimeMillis() - (long)seekPos;
            PlaylistSubscriberStream.this.notifyItemSeek(this.currentItem, seekPos);
            boolean messageSent = false;
            boolean startPullPushThread = false;
            if ((this.state == State.PAUSED || this.state == State.STOPPED) && this.sendCheckVideoCM(this.msgIn)) {
                IMessage msg;
                try {
                    msg = this.msgIn.pullMessage();
                }
                catch (Throwable err) {
                    log.error("Error while pulling message.", err);
                    msg = null;
                }
                while (msg != null) {
                    RTMPMessage rtmpMessage;
                    IRTMPEvent body;
                    if (msg instanceof RTMPMessage && (body = (rtmpMessage = (RTMPMessage)msg).getBody()) instanceof VideoData && ((VideoData)body).getFrameType() == VideoData.FrameType.KEYFRAME) {
                        body.setTimestamp(seekPos);
                        this.doPushMessage(rtmpMessage);
                        rtmpMessage.getBody().release();
                        messageSent = true;
                        this.lastMessage = body;
                        break;
                    }
                    try {
                        msg = this.msgIn.pullMessage();
                    }
                    catch (Throwable err) {
                        log.error("Error while pulling message.", err);
                        msg = null;
                    }
                }
            } else {
                startPullPushThread = true;
            }
            if (!messageSent) {
                AudioData audio = new AudioData();
                audio.setTimestamp(seekPos);
                audio.setHeader(new Header());
                audio.getHeader().setTimer(seekPos);
                audio.getHeader().setTimerRelative(false);
                RTMPMessage audioMessage = new RTMPMessage();
                audioMessage.setBody(audio);
                this.lastMessage = audio;
                this.doPushMessage(audioMessage);
            }
            if (startPullPushThread) {
                this.ensurePullAndPushRunning();
            }
            if (this.state != State.STOPPED && this.currentItem.getLength() >= 0L && (long)(position - this.streamOffset) >= this.currentItem.getLength()) {
                this.stop();
                return;
            }
        }

        public synchronized void stop() throws IllegalStateException {
            if (this.state != State.PLAYING && this.state != State.PAUSED) {
                throw new IllegalStateException();
            }
            this.state = State.STOPPED;
            if (this.msgIn != null && !this.isPullMode) {
                this.msgIn.unsubscribe(this);
                this.msgIn = null;
            }
            PlaylistSubscriberStream.this.notifyItemStop(this.currentItem);
            this.clearWaitJobs();
            if (!PlaylistSubscriberStream.this.hasMoreItems()) {
                this.releasePendingMessage();
                PlaylistSubscriberStream.this.bwController.resetBuckets(PlaylistSubscriberStream.this.bwContext);
                this.isWaitingForToken = false;
                if (PlaylistSubscriberStream.this.getItemSize() > 0) {
                    this.sendCompleteStatus();
                }
                this.bytesSent = 0L;
                this.sendClearPing();
                this.sendStopStatus(this.currentItem);
            } else {
                if (this.lastMessage != null) {
                    this.timestampOffset = this.lastMessage.getTimestamp();
                }
                PlaylistSubscriberStream.this.nextItem();
            }
        }

        public synchronized void close() {
            if (this.msgIn != null) {
                this.msgIn.unsubscribe(this);
                this.msgIn = null;
            }
            this.state = State.CLOSED;
            this.clearWaitJobs();
            this.releasePendingMessage();
            this.lastMessage = null;
            this.sendClearPing();
        }

        private boolean okayToSendMessage(IRTMPEvent message) {
            if (!(message instanceof IStreamData)) {
                throw new RuntimeException("expected IStreamData but got " + message.getClass() + " (type " + message.getDataType() + ")");
            }
            long now = System.currentTimeMillis();
            if (this.lastMessage != null) {
                long delta = now - this.playbackStart;
                long buffer = PlaylistSubscriberStream.this.getClientBufferDuration();
                long buffered = (long)this.lastMessage.getTimestamp() - delta;
                if (log.isDebugEnabled()) {
                    log.debug("okayToSendMessage: " + this.lastMessage.getTimestamp() + " " + delta + " " + buffered + " " + buffer);
                }
                if (buffer > 0L && buffered > buffer) {
                    return false;
                }
            }
            long pending = this.pendingMessages();
            if (PlaylistSubscriberStream.this.bufferCheckInterval > 0 && now >= this.nextCheckBufferUnderrun) {
                if (pending > (long)PlaylistSubscriberStream.this.underrunTrigger) {
                    this.sendInsufficientBandwidthStatus(this.currentItem);
                }
                this.nextCheckBufferUnderrun = now + (long)PlaylistSubscriberStream.this.bufferCheckInterval;
            }
            if (pending > (long)PlaylistSubscriberStream.this.underrunTrigger) {
                return false;
            }
            if (((IStreamData)((Object)message)).getData() == null) {
                return true;
            }
            int size = ((IStreamData)((Object)message)).getData().limit();
            if (message instanceof VideoData) {
                if (this.needCheckBandwidth && !this.videoBucket.acquireTokenNonblocking(size, this)) {
                    this.isWaitingForToken = true;
                    return false;
                }
            } else if (message instanceof AudioData && this.needCheckBandwidth && !this.audioBucket.acquireTokenNonblocking(size, this)) {
                this.isWaitingForToken = true;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensurePullAndPushRunning() {
            if (!this.isPullMode) {
                return;
            }
            if (this.pullAndPushFuture == null) {
                PlayEngine playEngine = this;
                synchronized (playEngine) {
                    if (this.pullAndPushFuture == null) {
                        this.pullAndPushFuture = PlaylistSubscriberStream.this.getExecutor().scheduleWithFixedDelay(new PullAndPushRunnable(), 0L, 10L, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }

        private synchronized void pullAndPush() throws IOException {
            block10: {
                if (this.state != State.PLAYING || !this.isPullMode || this.isWaitingForToken) break block10;
                if (this.pendingMessage != null) {
                    IRTMPEvent body = this.pendingMessage.getBody();
                    if (!this.okayToSendMessage(body)) {
                        return;
                    }
                    this.sendMessage(this.pendingMessage);
                    this.releasePendingMessage();
                } else {
                    IRTMPEvent body;
                    RTMPMessage rtmpMessage;
                    while (true) {
                        IMessage msg;
                        if ((msg = this.msgIn.pullMessage()) == null) {
                            this.stop();
                            break block10;
                        }
                        if (!(msg instanceof RTMPMessage)) continue;
                        rtmpMessage = (RTMPMessage)msg;
                        body = rtmpMessage.getBody();
                        if (!PlaylistSubscriberStream.this.receiveAudio && body instanceof AudioData) {
                            ((IStreamData)((Object)body)).getData().release();
                            if (!this.sendBlankAudio) continue;
                            this.sendBlankAudio = false;
                            body = new AudioData();
                            if (this.lastMessage != null) {
                                body.setTimestamp(this.lastMessage.getTimestamp() - this.timestampOffset);
                            } else {
                                body.setTimestamp(-this.timestampOffset);
                            }
                            rtmpMessage.setBody(body);
                            break;
                        }
                        if (PlaylistSubscriberStream.this.receiveVideo || !(body instanceof VideoData)) break;
                        ((IStreamData)((Object)body)).getData().release();
                    }
                    body.setTimestamp(body.getTimestamp() + this.timestampOffset);
                    if (this.okayToSendMessage(body)) {
                        this.sendMessage(rtmpMessage);
                        ((IStreamData)((Object)body)).getData().release();
                    } else {
                        this.pendingMessage = rtmpMessage;
                    }
                    this.ensurePullAndPushRunning();
                }
            }
        }

        private void clearWaitJobs() {
            if (this.pullAndPushFuture != null) {
                this.pullAndPushFuture.cancel(false);
                this.pullAndPushFuture = null;
            }
            if (this.waitLiveJob != null) {
                this.schedulingService.removeScheduledJob(this.waitLiveJob);
                this.waitLiveJob = null;
            }
        }

        private void doPushMessage(AbstractMessage message) {
            try {
                IRTMPEvent body;
                this.msgOut.pushMessage(message);
                if (message instanceof RTMPMessage && (body = ((RTMPMessage)message).getBody()) instanceof IStreamData && ((IStreamData)((Object)body)).getData() != null) {
                    this.bytesSent += (long)((IStreamData)((Object)body)).getData().limit();
                }
            }
            catch (IOException err) {
                log.error("Error while pushing message.", (Throwable)err);
            }
        }

        private void sendMessage(RTMPMessage message) {
            int duration;
            if (this.vodStartTS == -1) {
                this.vodStartTS = message.getBody().getTimestamp();
            } else if (this.currentItem.getLength() >= 0L && (long)((duration = message.getBody().getTimestamp() - this.vodStartTS) - this.streamOffset) >= this.currentItem.getLength()) {
                this.stop();
                return;
            }
            this.lastMessage = message.getBody();
            if (this.lastMessage instanceof IStreamData) {
                this.bytesSent += (long)((IStreamData)((Object)this.lastMessage)).getData().limit();
            }
            this.doPushMessage(message);
        }

        private void sendClearPing() {
            Ping ping1 = new Ping();
            ping1.setValue1((short)1);
            ping1.setValue2(PlaylistSubscriberStream.this.getStreamId());
            RTMPMessage ping1Msg = new RTMPMessage();
            ping1Msg.setBody(ping1);
            this.doPushMessage(ping1Msg);
        }

        private void sendReset() {
            if (this.isPullMode) {
                Ping ping1 = new Ping();
                ping1.setValue1((short)4);
                ping1.setValue2(PlaylistSubscriberStream.this.getStreamId());
                RTMPMessage ping1Msg = new RTMPMessage();
                ping1Msg.setBody(ping1);
                this.doPushMessage(ping1Msg);
            }
            Ping ping2 = new Ping();
            ping2.setValue1((short)0);
            ping2.setValue2(PlaylistSubscriberStream.this.getStreamId());
            RTMPMessage ping2Msg = new RTMPMessage();
            ping2Msg.setBody(ping2);
            this.doPushMessage(ping2Msg);
            ResetMessage reset = new ResetMessage();
            this.doPushMessage(reset);
        }

        private void sendResetStatus(IPlayItem item) {
            Status reset = new Status("NetStream.Play.Reset");
            reset.setClientid(PlaylistSubscriberStream.this.getStreamId());
            reset.setDetails(item.getName());
            reset.setDesciption("Playing and resetting " + item.getName() + '.');
            StatusMessage resetMsg = new StatusMessage();
            resetMsg.setBody(reset);
            this.doPushMessage(resetMsg);
        }

        private void sendStartStatus(IPlayItem item) {
            Status start = new Status("NetStream.Play.Start");
            start.setClientid(PlaylistSubscriberStream.this.getStreamId());
            start.setDetails(item.getName());
            start.setDesciption("Started playing " + item.getName() + '.');
            StatusMessage startMsg = new StatusMessage();
            startMsg.setBody(start);
            this.doPushMessage(startMsg);
        }

        private void sendStopStatus(IPlayItem item) {
            Status stop = new Status("NetStream.Play.Stop");
            stop.setClientid(PlaylistSubscriberStream.this.getStreamId());
            stop.setDesciption("Stopped playing " + item.getName() + ".");
            stop.setDetails(item.getName());
            StatusMessage stopMsg = new StatusMessage();
            stopMsg.setBody(stop);
            this.doPushMessage(stopMsg);
        }

        private void sendOnPlayStatus(String code, int duration, long bytes) {
            ByteBuffer buf = ByteBuffer.allocate((int)1024);
            buf.setAutoExpand(true);
            Output out = new Output(buf);
            out.writeString("onPlayStatus");
            HashMap<Object, Object> props = new HashMap<Object, Object>();
            props.put("code", code);
            props.put("level", "status");
            props.put("duration", duration);
            props.put("bytes", bytes);
            out.writeMap(props, new Serializer());
            buf.flip();
            Notify event = new Notify(buf);
            if (this.lastMessage != null) {
                int timestamp = this.lastMessage.getTimestamp();
                event.setTimestamp(timestamp);
            } else {
                event.setTimestamp(0);
            }
            RTMPMessage msg = new RTMPMessage();
            msg.setBody(event);
            this.doPushMessage(msg);
        }

        private void sendSwitchStatus() {
            int duration = 1;
            this.sendOnPlayStatus("NetStream.Play.Switch", duration, this.bytesSent);
        }

        private void sendCompleteStatus() {
            int duration = 1;
            this.sendOnPlayStatus("NetStream.Play.Complete", duration, this.bytesSent);
        }

        private void sendSeekStatus(IPlayItem item, int position) {
            Status seek = new Status("NetStream.Seek.Notify");
            seek.setClientid(PlaylistSubscriberStream.this.getStreamId());
            seek.setDetails(item.getName());
            seek.setDesciption("Seeking " + position + " (stream ID: " + PlaylistSubscriberStream.this.getStreamId() + ").");
            StatusMessage seekMsg = new StatusMessage();
            seekMsg.setBody(seek);
            this.doPushMessage(seekMsg);
        }

        private void sendPauseStatus(IPlayItem item) {
            Status pause = new Status("NetStream.Pause.Notify");
            pause.setClientid(PlaylistSubscriberStream.this.getStreamId());
            pause.setDetails(item.getName());
            StatusMessage pauseMsg = new StatusMessage();
            pauseMsg.setBody(pause);
            this.doPushMessage(pauseMsg);
        }

        private void sendResumeStatus(IPlayItem item) {
            Status resume = new Status("NetStream.Unpause.Notify");
            resume.setClientid(PlaylistSubscriberStream.this.getStreamId());
            resume.setDetails(item.getName());
            StatusMessage resumeMsg = new StatusMessage();
            resumeMsg.setBody(resume);
            this.doPushMessage(resumeMsg);
        }

        private void sendPublishedStatus(IPlayItem item) {
            Status published = new Status("NetStream.Play.PublishNotify");
            published.setClientid(PlaylistSubscriberStream.this.getStreamId());
            published.setDetails(item.getName());
            StatusMessage unpublishedMsg = new StatusMessage();
            unpublishedMsg.setBody(published);
            this.doPushMessage(unpublishedMsg);
        }

        private void sendUnpublishedStatus(IPlayItem item) {
            Status unpublished = new Status("NetStream.Play.UnpublishNotify");
            unpublished.setClientid(PlaylistSubscriberStream.this.getStreamId());
            unpublished.setDetails(item.getName());
            StatusMessage unpublishedMsg = new StatusMessage();
            unpublishedMsg.setBody(unpublished);
            this.doPushMessage(unpublishedMsg);
        }

        private void sendStreamNotFoundStatus(IPlayItem item) {
            Status notFound = new Status("NetStream.Play.StreamNotFound");
            notFound.setClientid(PlaylistSubscriberStream.this.getStreamId());
            notFound.setLevel("error");
            notFound.setDetails(item.getName());
            StatusMessage notFoundMsg = new StatusMessage();
            notFoundMsg.setBody(notFound);
            this.doPushMessage(notFoundMsg);
        }

        private void sendInsufficientBandwidthStatus(IPlayItem item) {
            Status insufficientBW = new Status("NetStream.Play.InsufficientBW");
            insufficientBW.setClientid(PlaylistSubscriberStream.this.getStreamId());
            insufficientBW.setLevel("warning");
            insufficientBW.setDetails(item.getName());
            insufficientBW.setDesciption("Data is playing behind the normal speed.");
            StatusMessage insufficientBWMsg = new StatusMessage();
            insufficientBWMsg.setBody(insufficientBW);
            this.doPushMessage(insufficientBWMsg);
        }

        private void sendVODInitCM(IMessageInput msgIn, IPlayItem item) {
            OOBControlMessage oobCtrlMsg = new OOBControlMessage();
            oobCtrlMsg.setTarget(IPassive.KEY);
            oobCtrlMsg.setServiceName("init");
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("startTS", (int)item.getStart());
            oobCtrlMsg.setServiceParamMap(paramMap);
            msgIn.sendOOBControlMessage(this, oobCtrlMsg);
        }

        private int sendVODSeekCM(IMessageInput msgIn, int position) {
            OOBControlMessage oobCtrlMsg = new OOBControlMessage();
            oobCtrlMsg.setTarget(ISeekableProvider.KEY);
            oobCtrlMsg.setServiceName("seek");
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("position", position);
            oobCtrlMsg.setServiceParamMap(paramMap);
            msgIn.sendOOBControlMessage(this, oobCtrlMsg);
            if (oobCtrlMsg.getResult() instanceof Integer) {
                return (Integer)oobCtrlMsg.getResult();
            }
            return -1;
        }

        private boolean sendCheckVideoCM(IMessageInput msgIn) {
            OOBControlMessage oobCtrlMsg = new OOBControlMessage();
            oobCtrlMsg.setTarget(IStreamTypeAwareProvider.KEY);
            oobCtrlMsg.setServiceName("hasVideo");
            msgIn.sendOOBControlMessage(this, oobCtrlMsg);
            if (oobCtrlMsg.getResult() instanceof Boolean) {
                return (Boolean)oobCtrlMsg.getResult();
            }
            return false;
        }

        public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
            if ("ConnectionConsumer".equals(oobCtrlMsg.getTarget()) && source instanceof IProvider) {
                this.msgOut.sendOOBControlMessage((IProvider)source, oobCtrlMsg);
            }
        }

        public void onPipeConnectionEvent(PipeConnectionEvent event) {
            switch (event.getType()) {
                case 1: {
                    if (event.getProvider() == this) break;
                    if (this.isWaiting) {
                        this.schedulingService.removeScheduledJob(this.waitLiveJob);
                        this.waitLiveJob = null;
                        this.isWaiting = false;
                    }
                    this.sendPublishedStatus(this.currentItem);
                    break;
                }
                case 2: {
                    if (this.isPullMode) {
                        this.sendStopStatus(this.currentItem);
                        break;
                    }
                    this.sendUnpublishedStatus(this.currentItem);
                    break;
                }
                case 3: {
                    if (event.getConsumer() != this) break;
                    this.isPullMode = true;
                    break;
                }
                case 4: {
                    if (event.getConsumer() != this) break;
                    this.isPullMode = false;
                    break;
                }
            }
        }

        public synchronized void pushMessage(IPipe pipe, IMessage message) throws IOException {
            if (message instanceof ResetMessage) {
                this.sendReset();
                return;
            }
            if (message instanceof RTMPMessage) {
                RTMPMessage rtmpMessage = (RTMPMessage)message;
                IRTMPEvent body = rtmpMessage.getBody();
                if (!(body instanceof IStreamData)) {
                    throw new RuntimeException("expected IStreamData but got " + body.getClass() + " (type " + body.getDataType() + ")");
                }
                int size = ((IStreamData)((Object)body)).getData().limit();
                if (body instanceof VideoData) {
                    IClientBroadcastStream stream;
                    IVideoStreamCodec videoCodec = null;
                    if (this.msgIn instanceof IBroadcastScope && (stream = (IClientBroadcastStream)((IBroadcastScope)this.msgIn).getAttribute("_transient_publishing_stream")) != null && stream.getCodecInfo() != null) {
                        videoCodec = stream.getCodecInfo().getVideoCodec();
                    }
                    if (videoCodec == null || videoCodec.canDropFrames()) {
                        boolean drop;
                        if (this.state == State.PAUSED) {
                            this.videoFrameDropper.dropPacket(rtmpMessage);
                            return;
                        }
                        long pendingVideos = this.pendingVideoMessages();
                        if (!this.videoFrameDropper.canSendPacket(rtmpMessage, pendingVideos)) {
                            return;
                        }
                        boolean bl = drop = !this.videoBucket.acquireToken(size, 0L);
                        if (!PlaylistSubscriberStream.this.receiveVideo || drop) {
                            this.videoFrameDropper.dropPacket(rtmpMessage);
                            return;
                        }
                        Long[] writeDelta = this.getWriteDelta();
                        if (pendingVideos > 1L) {
                            long now = System.currentTimeMillis();
                            if (PlaylistSubscriberStream.this.bufferCheckInterval > 0 && now >= this.nextCheckBufferUnderrun) {
                                this.sendInsufficientBandwidthStatus(this.currentItem);
                                this.nextCheckBufferUnderrun = now + (long)PlaylistSubscriberStream.this.bufferCheckInterval;
                            }
                            this.videoFrameDropper.dropPacket(rtmpMessage);
                            return;
                        }
                        this.videoFrameDropper.sendPacket(rtmpMessage);
                    }
                } else if (body instanceof AudioData) {
                    if (!PlaylistSubscriberStream.this.receiveAudio && this.sendBlankAudio) {
                        this.sendBlankAudio = false;
                        body = new AudioData();
                        if (this.lastMessage != null) {
                            body.setTimestamp(this.lastMessage.getTimestamp());
                        } else {
                            body.setTimestamp(0);
                        }
                        rtmpMessage.setBody(body);
                    } else if (this.state == State.PAUSED || !PlaylistSubscriberStream.this.receiveAudio || !this.audioBucket.acquireToken(size, 0L)) {
                        return;
                    }
                }
                if (body instanceof IStreamData && ((IStreamData)((Object)body)).getData() != null) {
                    this.bytesSent += (long)((IStreamData)((Object)body)).getData().limit();
                }
                this.lastMessage = body;
            }
            this.msgOut.pushMessage(message);
        }

        public synchronized void available(ITokenBucket bucket, long tokenCount) {
            this.isWaitingForToken = false;
            this.needCheckBandwidth = false;
            try {
                this.pullAndPush();
            }
            catch (Throwable err) {
                log.error("Error while pulling message.", err);
            }
            this.needCheckBandwidth = true;
        }

        public void reset(ITokenBucket bucket, long tokenCount) {
            this.isWaitingForToken = false;
        }

        public void updateBandwithConfigure() {
            PlaylistSubscriberStream.this.bwController.updateBWConfigure(PlaylistSubscriberStream.this.bwContext);
        }

        private long pendingVideoMessages() {
            OOBControlMessage pendingRequest = new OOBControlMessage();
            pendingRequest.setTarget("ConnectionConsumer");
            pendingRequest.setServiceName("pendingVideoCount");
            this.msgOut.sendOOBControlMessage(this, pendingRequest);
            if (pendingRequest.getResult() != null) {
                return (Long)pendingRequest.getResult();
            }
            return 0L;
        }

        private long pendingMessages() {
            return PlaylistSubscriberStream.this.getConnection().getPendingMessages();
        }

        private Long[] getWriteDelta() {
            OOBControlMessage pendingRequest = new OOBControlMessage();
            pendingRequest.setTarget("ConnectionConsumer");
            pendingRequest.setServiceName("writeDelta");
            this.msgOut.sendOOBControlMessage(this, pendingRequest);
            if (pendingRequest.getResult() != null) {
                return (Long[])pendingRequest.getResult();
            }
            return new Long[]{0L, 0L};
        }

        private synchronized void releasePendingMessage() {
            if (this.pendingMessage != null) {
                IRTMPEvent body = this.pendingMessage.getBody();
                if (body instanceof IStreamData && ((IStreamData)((Object)body)).getData() != null) {
                    ((IStreamData)((Object)body)).getData().release();
                }
                this.pendingMessage.setBody(null);
                this.pendingMessage = null;
            }
        }

        private class PullAndPushRunnable
        implements Runnable {
            private PullAndPushRunnable() {
            }

            public void run() {
                try {
                    PlayEngine.this.pullAndPush();
                }
                catch (IOException err) {
                    log.error("Error while getting message.", (Throwable)err);
                    PlayEngine.this.stop();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNINIT,
        STOPPED,
        PLAYING,
        PAUSED,
        CLOSED;

    }
}

