/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.red5.io.IStreamableFileFactory;
import org.red5.io.IStreamableFileService;
import org.red5.server.api.IBasicScope;
import org.red5.server.api.IScope;
import org.red5.server.api.ScopeUtils;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IStreamFilenameGenerator;
import org.red5.server.messaging.IMessageInput;
import org.red5.server.messaging.InMemoryPullPullPipe;
import org.red5.server.stream.BroadcastScope;
import org.red5.server.stream.DefaultStreamFilenameGenerator;
import org.red5.server.stream.IBroadcastScope;
import org.red5.server.stream.IProviderService;
import org.red5.server.stream.provider.FileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderService
implements IProviderService {
    private static final Logger log = LoggerFactory.getLogger(ProviderService.class);

    @Override
    public IMessageInput getProviderInput(IScope scope, String name) {
        IMessageInput msgIn = this.getLiveProviderInput(scope, name, false);
        if (msgIn == null) {
            return this.getVODProviderInput(scope, name);
        }
        return msgIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMessageInput getLiveProviderInput(IScope scope, String name, boolean needCreate) {
        IBasicScope basicScope = scope.getBasicScope("bs", name);
        if (basicScope == null) {
            if (needCreate) {
                IScope iScope = scope;
                synchronized (iScope) {
                    basicScope = scope.getBasicScope("bs", name);
                    if (basicScope == null) {
                        basicScope = new BroadcastScope(scope, name);
                        scope.addChildScope(basicScope);
                    }
                }
            } else {
                return null;
            }
        }
        if (!(basicScope instanceof IBroadcastScope)) {
            return null;
        }
        return (IBroadcastScope)basicScope;
    }

    @Override
    public IMessageInput getVODProviderInput(IScope scope, String name) {
        File file = this.getVODProviderFile(scope, name);
        if (file == null) {
            return null;
        }
        InMemoryPullPullPipe pipe = new InMemoryPullPullPipe();
        pipe.subscribe(new FileProvider(scope, file), null);
        return pipe;
    }

    @Override
    public File getVODProviderFile(IScope scope, String name) {
        File file = null;
        try {
            log.info("getVODProviderFile scope path: " + scope.getContextPath() + " name: " + name);
            file = this.getStreamFile(scope, name);
        }
        catch (IOException e) {
            log.error("Problem getting file: " + name);
        }
        if (file == null || !file.exists()) {
            return null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerBroadcastStream(IScope scope, String name, IBroadcastStream bs) {
        boolean status = false;
        IScope iScope = scope;
        synchronized (iScope) {
            IBasicScope basicScope = scope.getBasicScope("bs", name);
            if (basicScope == null) {
                basicScope = new BroadcastScope(scope, name);
                scope.addChildScope(basicScope);
            }
            if (basicScope instanceof IBroadcastScope) {
                ((IBroadcastScope)basicScope).subscribe(bs.getProvider(), null);
                status = true;
            }
        }
        return status;
    }

    @Override
    public List<String> getBroadcastStreamNames(IScope scope) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> it = scope.getBasicScopeNames("bs");
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregisterBroadcastStream(IScope scope, String name) {
        boolean status = false;
        IScope iScope = scope;
        synchronized (iScope) {
            IBasicScope basicScope = scope.getBasicScope("bs", name);
            if (basicScope instanceof IBroadcastScope) {
                scope.removeChildScope(basicScope);
                status = true;
            }
        }
        return status;
    }

    private File getStreamFile(IScope scope, String name) throws IOException {
        IStreamableFileFactory factory = (IStreamableFileFactory)ScopeUtils.getScopeService(scope, IStreamableFileFactory.class);
        if (name.indexOf(58) == -1 && name.indexOf(46) == -1) {
            name = "flv:" + name;
        }
        log.info("getStreamFile null check - factory: " + factory + " name: " + name);
        for (IStreamableFileService service : factory.getServices()) {
            if (!name.startsWith(service.getPrefix() + ':')) continue;
            name = service.prepareFilename(name);
            break;
        }
        IStreamFilenameGenerator filenameGenerator = (IStreamFilenameGenerator)ScopeUtils.getScopeService(scope, IStreamFilenameGenerator.class, DefaultStreamFilenameGenerator.class);
        String filename = filenameGenerator.generateFilename(scope, name, IStreamFilenameGenerator.GenerationType.PLAYBACK);
        File file = filenameGenerator.resolvesToAbsolutePath() ? new File(filename) : scope.getContext().getResource(filename).getFile();
        return file;
    }
}

