/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.red5.server.api.IBWControllable;
import org.red5.server.stream.IBWControlContext;
import org.red5.server.stream.IBWControlService;
import org.red5.server.stream.ITokenBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBWControlService
extends TimerTask
implements IBWControlService {
    private static final Logger log = LoggerFactory.getLogger(SimpleBWControlService.class);
    protected Map<IBWControllable, BWContext> contextMap = new ConcurrentHashMap<IBWControllable, BWContext>();
    protected Timer tokenDistributor;
    protected long interval;
    protected long defaultCapacity;

    public void init() {
        this.tokenDistributor = new Timer("Token Distributor", true);
        this.tokenDistributor.scheduleAtFixedRate((TimerTask)this, 0L, this.interval);
    }

    public void shutdown() {
        this.tokenDistributor.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BWContext bWContext;
        BWContext context;
        if (this.contextMap.isEmpty()) {
            return;
        }
        Collection<BWContext> contexts = this.contextMap.values();
        Iterator<BWContext> i$ = contexts.iterator();
        while (i$.hasNext()) {
            bWContext = context = i$.next();
            synchronized (bWContext) {
                if (context.bwConfig != null) {
                    long t = System.currentTimeMillis();
                    long delta = t - context.lastSchedule;
                    context.lastSchedule = t;
                    if (context.bwConfig[3] >= 0L) {
                        if ((double)this.defaultCapacity >= context.tokenRc[3]) {
                            context.tokenRc[3] = context.tokenRc[3] + (double)context.bwConfig[3] * (double)delta / 8000.0;
                        }
                    } else {
                        for (int i = 0; i < 3; ++i) {
                            if (context.bwConfig[i] < 0L || !((double)this.defaultCapacity >= context.tokenRc[i])) continue;
                            int n = i;
                            context.tokenRc[n] = context.tokenRc[n] + (double)context.bwConfig[i] * (double)delta / 8000.0;
                        }
                    }
                }
            }
        }
        i$ = contexts.iterator();
        while (i$.hasNext()) {
            bWContext = context = i$.next();
            synchronized (bWContext) {
                context.notifyAll();
                this.invokeCallback(context);
            }
        }
    }

    public ITokenBucket getAudioBucket(IBWControlContext context) {
        if (!(context instanceof BWContext)) {
            return null;
        }
        BWContext c = (BWContext)context;
        return c.buckets[0];
    }

    public ITokenBucket getVideoBucket(IBWControlContext context) {
        if (!(context instanceof BWContext)) {
            return null;
        }
        BWContext c = (BWContext)context;
        return c.buckets[1];
    }

    public ITokenBucket getDataBucket(IBWControlContext context) {
        if (!(context instanceof BWContext)) {
            return null;
        }
        BWContext c = (BWContext)context;
        return c.buckets[2];
    }

    public IBWControlContext registerBWControllable(IBWControllable bc) {
        int i;
        BWContext context = new BWContext(bc);
        long[] channelInitialBurst = null;
        if (bc.getBandwidthConfigure() != null) {
            context.bwConfig = new long[4];
            for (i = 0; i < 4; ++i) {
                context.bwConfig[i] = bc.getBandwidthConfigure().getChannelBandwidth()[i];
            }
            channelInitialBurst = bc.getBandwidthConfigure().getChannelInitialBurst();
        }
        context.buckets[0] = new Bucket(bc, 0);
        context.buckets[1] = new Bucket(bc, 1);
        context.buckets[2] = new Bucket(bc, 2);
        context.tokenRc = new double[4];
        if (context.bwConfig != null) {
            for (i = 0; i < 4; ++i) {
                context.tokenRc[i] = channelInitialBurst[i] >= 0L ? (double)channelInitialBurst[i] : (double)(this.defaultCapacity / 2L);
            }
            context.lastSchedule = System.currentTimeMillis();
        } else {
            context.lastSchedule = -1L;
        }
        this.contextMap.put(bc, context);
        return context;
    }

    public void resetBuckets(IBWControlContext context) {
        if (!(context instanceof BWContext)) {
            return;
        }
        BWContext c = (BWContext)context;
        for (int i = 0; i < 3; ++i) {
            c.buckets[i].reset();
        }
    }

    public void unregisterBWControllable(IBWControlContext context) {
        this.resetBuckets(context);
        this.contextMap.remove(context.getBWControllable());
    }

    public IBWControlContext lookupContext(IBWControllable bc) {
        return this.contextMap.get(bc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBWConfigure(IBWControlContext context) {
        if (!(context instanceof BWContext)) {
            return;
        }
        BWContext c = (BWContext)context;
        IBWControllable bc = c.getBWControllable();
        BWContext bWContext = c;
        synchronized (bWContext) {
            if (bc.getBandwidthConfigure() == null) {
                c.bwConfig = null;
                c.lastSchedule = -1L;
            } else {
                int i;
                long[] oldConfig = c.bwConfig;
                c.bwConfig = new long[4];
                for (i = 0; i < 4; ++i) {
                    c.bwConfig[i] = bc.getBandwidthConfigure().getChannelBandwidth()[i];
                }
                if (oldConfig == null) {
                    c.lastSchedule = System.currentTimeMillis();
                    long[] channelInitialBurst = bc.getBandwidthConfigure().getChannelInitialBurst();
                    for (int i2 = 0; i2 < 4; ++i2) {
                        c.tokenRc[i2] = channelInitialBurst[i2] >= 0L ? (double)channelInitialBurst[i2] : (double)(this.defaultCapacity / 2L);
                    }
                } else if (c.bwConfig[3] >= 0L && oldConfig[3] < 0L) {
                    c.tokenRc[3] = c.tokenRc[3] + (c.tokenRc[0] + c.tokenRc[1] + c.tokenRc[2]);
                    for (i = 0; i < 3; ++i) {
                        c.tokenRc[i] = 0.0;
                    }
                } else if (c.bwConfig[3] < 0L && oldConfig[3] >= 0L) {
                    for (i = 0; i < 3; ++i) {
                        if (c.bwConfig[i] < 0L) continue;
                        int n = i;
                        c.tokenRc[n] = c.tokenRc[n] + c.tokenRc[3];
                        break;
                    }
                    c.tokenRc[3] = 0.0;
                }
            }
        }
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setDefaultCapacity(long capacity) {
        this.defaultCapacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processRequest(TokenRequest request) {
        for (IBWControllable bc = request.initialBC; bc != null; bc = bc.getParentBWControllable()) {
            BWContext context = this.contextMap.get(bc);
            if (context == null) {
                this.rollbackRequest(request);
                return false;
            }
            BWContext bWContext = context;
            synchronized (bWContext) {
                boolean result;
                if (context.bwConfig != null && !(result = request.type == TokenRequestType.BLOCKING ? this.processBlockingRequest(request, context) : (request.type == TokenRequestType.NONBLOCKING ? this.processNonblockingRequest(request, context) : this.processBestEffortRequest(request, context)))) {
                    if (request.type != TokenRequestType.NONBLOCKING) {
                        this.rollbackRequest(request);
                    }
                    return false;
                }
                TokenRequestContext requestContext = new TokenRequestContext();
                requestContext.acquiredToken = request.requestToken;
                requestContext.bc = bc;
                request.acquiredStack.push(requestContext);
                continue;
            }
        }
        if (request.type == TokenRequestType.BEST_EFFORT) {
            this.rollbackRequest(request);
        }
        return true;
    }

    private boolean processBlockingRequest(TokenRequest request, BWContext context) {
        context.timeToWait = request.timeout;
        do {
            if (context.bwConfig[3] >= 0L) {
                if (context.tokenRc[3] >= request.requestToken) {
                    context.tokenRc[3] = context.tokenRc[3] - request.requestToken;
                    request.timeout = context.timeToWait;
                    return true;
                }
            } else {
                if (context.tokenRc[request.channel] < 0.0) {
                    return true;
                }
                if (context.tokenRc[request.channel] >= request.requestToken) {
                    int n = request.channel;
                    context.tokenRc[n] = context.tokenRc[n] - request.requestToken;
                    request.timeout = context.timeToWait;
                    return true;
                }
            }
            long beforeWait = System.currentTimeMillis();
            try {
                context.wait(context.timeToWait);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            context.timeToWait -= System.currentTimeMillis() - beforeWait;
        } while (context.timeToWait > 0L);
        return false;
    }

    private boolean processNonblockingRequest(TokenRequest request, BWContext context) {
        if (context.bwConfig[3] >= 0L) {
            if (context.tokenRc[3] >= request.requestToken) {
                context.tokenRc[3] = context.tokenRc[3] - request.requestToken;
                return true;
            }
        } else {
            if (context.tokenRc[request.channel] < 0.0) {
                return true;
            }
            if (context.tokenRc[request.channel] >= request.requestToken) {
                int n = request.channel;
                context.tokenRc[n] = context.tokenRc[n] - request.requestToken;
                return true;
            }
        }
        context.pendingRequestArray[request.channel].add(request);
        return false;
    }

    private boolean processBestEffortRequest(TokenRequest request, BWContext context) {
        if (context.bwConfig[3] >= 0L) {
            if (context.tokenRc[3] >= request.requestToken) {
                context.tokenRc[3] = context.tokenRc[3] - request.requestToken;
            } else {
                request.requestToken = context.tokenRc[3];
                context.tokenRc[3] = 0.0;
            }
        } else {
            if (context.tokenRc[request.channel] < 0.0) {
                return true;
            }
            if (context.tokenRc[request.channel] >= request.requestToken) {
                int n = request.channel;
                context.tokenRc[n] = context.tokenRc[n] - request.requestToken;
            } else {
                request.requestToken = context.tokenRc[request.channel];
                context.tokenRc[request.channel] = 0.0;
            }
        }
        return request.requestToken != 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeCallback(BWContext context) {
        for (int i = 0; i < 3; ++i) {
            List<TokenRequest> pendingList = context.pendingRequestArray[i];
            if (pendingList.isEmpty()) continue;
            for (TokenRequest request : pendingList) {
                BWContext c;
                IBWControllable bc;
                for (bc = context.getBWControllable(); bc != null && (c = this.contextMap.get(bc)) != null; bc = bc.getParentBWControllable()) {
                    BWContext bWContext = c;
                    synchronized (bWContext) {
                        if (c.bwConfig != null && !this.processNonblockingRequest(request, c)) {
                            break;
                        }
                    }
                    TokenRequestContext requestContext = new TokenRequestContext();
                    requestContext.acquiredToken = request.requestToken;
                    requestContext.bc = bc;
                    request.acquiredStack.push(requestContext);
                }
                if (bc != null) continue;
                try {
                    request.callback.available(context.buckets[request.channel], (long)request.requestToken);
                }
                catch (Throwable t) {
                    log.error("Error calling request's callback", t);
                }
            }
            pendingList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackRequest(TokenRequest request) {
        while (!request.acquiredStack.isEmpty()) {
            TokenRequestContext requestContext = request.acquiredStack.pop();
            BWContext context = this.contextMap.get(requestContext.bc);
            if (context == null) continue;
            BWContext bWContext = context;
            synchronized (bWContext) {
                if (context.bwConfig != null) {
                    if (context.bwConfig[3] >= 0L) {
                        context.tokenRc[3] = request.type == TokenRequestType.BEST_EFFORT ? context.tokenRc[3] + (requestContext.acquiredToken - request.requestToken) : context.tokenRc[3] + requestContext.acquiredToken;
                    } else if (context.bwConfig[request.channel] >= 0L) {
                        if (request.type == TokenRequestType.BEST_EFFORT) {
                            int n = request.channel;
                            context.tokenRc[n] = context.tokenRc[n] + (requestContext.acquiredToken - request.requestToken);
                        } else {
                            int n = request.channel;
                            context.tokenRc[n] = context.tokenRc[n] + requestContext.acquiredToken;
                        }
                    }
                }
            }
        }
    }

    protected class BWContext
    implements IBWControlContext {
        long[] bwConfig;
        double[] tokenRc = new double[4];
        ITokenBucket[] buckets = new ITokenBucket[3];
        List<TokenRequest>[] pendingRequestArray = null;
        long lastSchedule;
        long timeToWait;
        private IBWControllable controllable;

        public BWContext(IBWControllable controllable) {
            this.controllable = controllable;
            Arrays.fill(this.tokenRc, 0.0);
            this.pendingRequestArray = new List[]{new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList()};
        }

        public IBWControllable getBWControllable() {
            return this.controllable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TokenRequestType {
        BLOCKING,
        NONBLOCKING,
        BEST_EFFORT;

    }

    protected class TokenRequestContext {
        IBWControllable bc;
        double acquiredToken;

        protected TokenRequestContext() {
        }
    }

    protected class TokenRequest {
        TokenRequestType type;
        ITokenBucket.ITokenBucketCallback callback;
        long timeout;
        int channel;
        IBWControllable initialBC;
        double requestToken;
        Stack<TokenRequestContext> acquiredStack = new Stack();

        protected TokenRequest() {
        }
    }

    private class Bucket
    implements ITokenBucket {
        private IBWControllable bc;
        private int channel;

        public Bucket(IBWControllable bc, int channel) {
            this.bc = bc;
            this.channel = channel;
        }

        public boolean acquireToken(long tokenCount, long wait) {
            if (wait < 0L) {
                return false;
            }
            TokenRequest request = new TokenRequest();
            request.type = TokenRequestType.BLOCKING;
            request.timeout = wait;
            request.channel = this.channel;
            request.initialBC = this.bc;
            request.requestToken = tokenCount;
            return SimpleBWControlService.this.processRequest(request);
        }

        public long acquireTokenBestEffort(long upperLimitCount) {
            TokenRequest request = new TokenRequest();
            request.type = TokenRequestType.BEST_EFFORT;
            request.channel = this.channel;
            request.initialBC = this.bc;
            request.requestToken = upperLimitCount;
            if (SimpleBWControlService.this.processRequest(request)) {
                return (long)request.requestToken;
            }
            return 0L;
        }

        public boolean acquireTokenNonblocking(long tokenCount, ITokenBucket.ITokenBucketCallback callback) {
            TokenRequest request = new TokenRequest();
            request.type = TokenRequestType.NONBLOCKING;
            request.callback = callback;
            request.channel = this.channel;
            request.initialBC = this.bc;
            request.requestToken = tokenCount;
            return SimpleBWControlService.this.processRequest(request);
        }

        public long getCapacity() {
            return SimpleBWControlService.this.defaultCapacity;
        }

        public double getSpeed() {
            BWContext context = SimpleBWControlService.this.contextMap.get(this.bc);
            if (context.bwConfig[3] >= 0L) {
                return context.bwConfig[3] * 1000L / 8L;
            }
            if (context.bwConfig[this.channel] >= 0L) {
                return context.bwConfig[this.channel] * 1000L / 8L;
            }
            return -1.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            BWContext context;
            for (IBWControllable bc = this.bc; bc != null && (context = SimpleBWControlService.this.contextMap.get(bc)) != null; bc = bc.getParentBWControllable()) {
                BWContext bWContext = context;
                synchronized (bWContext) {
                    List<TokenRequest> pendingList = context.pendingRequestArray[this.channel];
                    TokenRequest toRemove = null;
                    for (TokenRequest request : pendingList) {
                        if (request.initialBC != this.bc) continue;
                        SimpleBWControlService.this.rollbackRequest(request);
                        toRemove = request;
                        break;
                    }
                    if (toRemove != null) {
                        pendingList.remove(toRemove);
                        try {
                            toRemove.callback.reset(this, (long)toRemove.requestToken);
                        }
                        catch (Throwable t) {
                            log.error("Error reset request's callback", t);
                        }
                        break;
                    }
                    continue;
                }
            }
        }
    }
}

