/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.IOException;
import java.util.Set;
import org.red5.server.BaseConnection;
import org.red5.server.api.IBasicScope;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.IScope;
import org.red5.server.api.Red5;
import org.red5.server.api.ScopeUtils;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.api.stream.IPlaylistSubscriberStream;
import org.red5.server.api.stream.ISingleItemSubscriberStream;
import org.red5.server.api.stream.IStreamCapableConnection;
import org.red5.server.api.stream.IStreamPlaybackSecurity;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.red5.server.api.stream.IStreamSecurityService;
import org.red5.server.api.stream.IStreamService;
import org.red5.server.api.stream.ISubscriberStream;
import org.red5.server.api.stream.OperationNotSupportedException;
import org.red5.server.api.stream.support.SimplePlayItem;
import org.red5.server.net.rtmp.BaseRTMPHandler;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.status.Status;
import org.red5.server.stream.IBroadcastScope;
import org.red5.server.stream.IProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamService
implements IStreamService {
    private static Logger logger = LoggerFactory.getLogger(StreamService.class);

    public void closeStream() {
        IConnection conn = Red5.getConnectionLocal();
        if (!(conn instanceof IStreamCapableConnection)) {
            return;
        }
        IClientStream stream = ((IStreamCapableConnection)conn).getStreamById(this.getCurrentStreamId());
        if (stream != null) {
            if (stream instanceof IClientBroadcastStream) {
                IClientBroadcastStream bs = (IClientBroadcastStream)stream;
                IBroadcastScope bsScope = this.getBroadcastScope(conn.getScope(), bs.getPublishedName());
                if (bsScope != null && conn instanceof BaseConnection) {
                    ((BaseConnection)conn).unregisterBasicScope(bsScope);
                }
            }
            stream.close();
        }
        ((IStreamCapableConnection)conn).deleteStreamById(this.getCurrentStreamId());
    }

    public int createStream() {
        IConnection conn = Red5.getConnectionLocal();
        if (!(conn instanceof IStreamCapableConnection)) {
            return -1;
        }
        return ((IStreamCapableConnection)conn).reserveStreamId();
    }

    public void deleteStream(int streamId) {
        IConnection conn = Red5.getConnectionLocal();
        if (!(conn instanceof IStreamCapableConnection)) {
            return;
        }
        IStreamCapableConnection streamConn = (IStreamCapableConnection)conn;
        this.deleteStream(streamConn, streamId);
    }

    public void deleteStream(IStreamCapableConnection conn, int streamId) {
        IClientStream stream = conn.getStreamById(streamId);
        if (stream != null) {
            if (stream instanceof IClientBroadcastStream) {
                IClientBroadcastStream bs = (IClientBroadcastStream)stream;
                IBroadcastScope bsScope = this.getBroadcastScope(conn.getScope(), bs.getPublishedName());
                if (bsScope != null && conn instanceof BaseConnection) {
                    ((BaseConnection)((Object)conn)).unregisterBasicScope(bsScope);
                }
            }
            stream.close();
        }
        conn.unreserveStreamId(streamId);
    }

    public void releaseStream(String streamName) {
    }

    public void pause(boolean pausePlayback, int position) {
        this.pause((Boolean)pausePlayback, position);
    }

    public void pause(Boolean pausePlayback, int position) {
        IConnection conn = Red5.getConnectionLocal();
        if (!(conn instanceof IStreamCapableConnection)) {
            return;
        }
        IStreamCapableConnection streamConn = (IStreamCapableConnection)conn;
        int streamId = this.getCurrentStreamId();
        IClientStream stream = streamConn.getStreamById(streamId);
        if (stream == null || !(stream instanceof ISubscriberStream)) {
            return;
        }
        ISubscriberStream subscriberStream = (ISubscriberStream)stream;
        if (pausePlayback == null) {
            pausePlayback = !subscriberStream.isPaused();
        }
        if (pausePlayback.booleanValue()) {
            subscriberStream.pause(position);
        } else {
            subscriberStream.resume(position);
        }
    }

    public void play(String name, int start, int length, Object flushPlaylist) {
        if (flushPlaylist instanceof Boolean) {
            this.play(name, start, length, (Boolean)flushPlaylist);
        } else {
            this.play(name, start, length);
        }
    }

    public void play(String name, int start, int length, boolean flushPlaylist) {
        IConnection conn = Red5.getConnectionLocal();
        if (!(conn instanceof IStreamCapableConnection)) {
            return;
        }
        IScope scope = conn.getScope();
        IStreamCapableConnection streamConn = (IStreamCapableConnection)conn;
        int streamId = this.getCurrentStreamId();
        if (name == null || "".equals(name)) {
            this.sendNSFailed((RTMPConnection)streamConn, "The stream name may not be empty.", name, streamId);
            return;
        }
        IStreamSecurityService security = (IStreamSecurityService)ScopeUtils.getScopeService(scope, IStreamSecurityService.class);
        if (security != null) {
            Set<IStreamPlaybackSecurity> handlers = security.getStreamPlaybackSecurity();
            for (IStreamPlaybackSecurity handler : handlers) {
                if (handler.isPlaybackAllowed(scope, name, start, length, flushPlaylist)) continue;
                this.sendNSFailed((RTMPConnection)streamConn, "You are not allowed to play the stream.", name, streamId);
                return;
            }
        }
        IClientStream stream = streamConn.getStreamById(streamId);
        boolean created = false;
        if (stream == null) {
            stream = streamConn.newPlaylistSubscriberStream(streamId);
            stream.start();
            created = true;
        }
        if (!(stream instanceof ISubscriberStream)) {
            return;
        }
        ISubscriberStream subscriberStream = (ISubscriberStream)stream;
        SimplePlayItem item = new SimplePlayItem();
        item.setName(name);
        item.setStart(start);
        item.setLength(length);
        if (subscriberStream instanceof IPlaylistSubscriberStream) {
            IPlaylistSubscriberStream playlistStream = (IPlaylistSubscriberStream)subscriberStream;
            if (flushPlaylist) {
                playlistStream.removeAllItems();
            }
            playlistStream.addItem(item);
        } else if (subscriberStream instanceof ISingleItemSubscriberStream) {
            ISingleItemSubscriberStream singleStream = (ISingleItemSubscriberStream)subscriberStream;
            singleStream.setPlayItem(item);
        } else {
            return;
        }
        try {
            subscriberStream.play();
        }
        catch (IOException err) {
            if (created) {
                stream.close();
                streamConn.deleteStreamById(streamId);
            }
            this.sendNSFailed((RTMPConnection)streamConn, err.getMessage(), name, streamId);
        }
    }

    public void play(String name, int start, int length) {
        this.play(name, start, length, true);
    }

    public void play(String name, int start) {
        this.play(name, start, -1000, true);
    }

    public void play(String name) {
        this.play(name, -2000, -1000, true);
    }

    public void play(Boolean dontStop) {
        if (!dontStop.booleanValue()) {
            IConnection conn = Red5.getConnectionLocal();
            if (!(conn instanceof IStreamCapableConnection)) {
                return;
            }
            IStreamCapableConnection streamConn = (IStreamCapableConnection)conn;
            int streamId = this.getCurrentStreamId();
            IClientStream stream = streamConn.getStreamById(streamId);
            if (stream != null) {
                stream.stop();
            }
        }
    }

    public void publish(Boolean dontStop) {
        if (!dontStop.booleanValue()) {
            IConnection conn = Red5.getConnectionLocal();
            if (!(conn instanceof IStreamCapableConnection)) {
                return;
            }
            IStreamCapableConnection streamConn = (IStreamCapableConnection)conn;
            int streamId = this.getCurrentStreamId();
            IClientStream stream = streamConn.getStreamById(streamId);
            if (!(stream instanceof IBroadcastStream)) {
                return;
            }
            IBroadcastStream bs = (IBroadcastStream)((Object)stream);
            if (bs.getPublishedName() == null) {
                return;
            }
            IBroadcastScope bsScope = this.getBroadcastScope(conn.getScope(), bs.getPublishedName());
            if (bsScope != null) {
                bsScope.unsubscribe(bs.getProvider());
                if (conn instanceof BaseConnection) {
                    ((BaseConnection)conn).unregisterBasicScope(bsScope);
                }
            }
            bs.close();
            streamConn.deleteStreamById(streamId);
        }
    }

    public void publish(String name, String mode) {
        IBroadcastScope bsScope;
        IConnection conn = Red5.getConnectionLocal();
        if (!(conn instanceof IStreamCapableConnection)) {
            return;
        }
        IScope scope = conn.getScope();
        IStreamCapableConnection streamConn = (IStreamCapableConnection)conn;
        int streamId = this.getCurrentStreamId();
        if (name == null || "".equals(name)) {
            this.sendNSFailed((RTMPConnection)streamConn, "The stream name may not be empty.", name, streamId);
            return;
        }
        IStreamSecurityService security = (IStreamSecurityService)ScopeUtils.getScopeService(scope, IStreamSecurityService.class);
        if (security != null) {
            Set<IStreamPublishSecurity> handlers = security.getStreamPublishSecurity();
            for (IStreamPublishSecurity handler : handlers) {
                if (handler.isPublishAllowed(scope, name, mode)) continue;
                this.sendNSFailed((RTMPConnection)streamConn, "You are not allowed to publish the stream.", name, streamId);
                return;
            }
        }
        if ((bsScope = this.getBroadcastScope(scope, name)) != null && !bsScope.getProviders().isEmpty()) {
            Status badName = new Status("NetStream.Publish.BadName");
            badName.setClientid(streamId);
            badName.setDetails(name);
            badName.setLevel("error");
            Channel channel = ((RTMPConnection)streamConn).getChannel((byte)(4 + (streamId - 1) * 5));
            channel.sendStatus(badName);
            return;
        }
        IClientStream stream = streamConn.getStreamById(streamId);
        if (stream != null && !(stream instanceof IClientBroadcastStream)) {
            return;
        }
        boolean created = false;
        if (stream == null) {
            stream = streamConn.newBroadcastStream(streamId);
            created = true;
        }
        IClientBroadcastStream bs = (IClientBroadcastStream)stream;
        try {
            bs.setPublishedName(name);
            IContext context = conn.getScope().getContext();
            IProviderService providerService = (IProviderService)context.getBean("providerService");
            if (providerService.registerBroadcastStream(conn.getScope(), name, bs)) {
                bsScope = this.getBroadcastScope(conn.getScope(), name);
                bsScope.setAttribute("_transient_publishing_stream", bs);
                if (conn instanceof BaseConnection) {
                    ((BaseConnection)conn).registerBasicScope(bsScope);
                }
            }
            if ("record".equals(mode)) {
                bs.start();
                bs.saveAs(name, false);
            } else if ("append".equals(mode)) {
                bs.start();
                bs.saveAs(name, true);
            } else if ("live".equals(mode)) {
                bs.start();
            }
            bs.startPublishing();
        }
        catch (IOException e) {
            Status accessDenied = new Status("NetStream.Record.NoAccess");
            accessDenied.setClientid(streamId);
            accessDenied.setDesciption("The file could not be created/written to.");
            accessDenied.setDetails(name);
            accessDenied.setLevel("error");
            Channel channel = ((RTMPConnection)streamConn).getChannel((byte)(4 + (streamId - 1) * 5));
            channel.sendStatus(accessDenied);
            bs.close();
            if (created) {
                streamConn.deleteStreamById(streamId);
            }
            return;
        }
        catch (Exception e) {
            logger.warn("publish caught Exception");
        }
    }

    public void publish(String name) {
        this.publish(name, "live");
    }

    public void seek(int position) {
        IConnection conn = Red5.getConnectionLocal();
        if (!(conn instanceof IStreamCapableConnection)) {
            return;
        }
        IStreamCapableConnection streamConn = (IStreamCapableConnection)conn;
        int streamId = this.getCurrentStreamId();
        IClientStream stream = streamConn.getStreamById(streamId);
        if (stream == null || !(stream instanceof ISubscriberStream)) {
            return;
        }
        ISubscriberStream subscriberStream = (ISubscriberStream)stream;
        try {
            subscriberStream.seek(position);
        }
        catch (OperationNotSupportedException err) {
            Status seekFailed = new Status("NetStream.Seek.Failed");
            seekFailed.setClientid(streamId);
            seekFailed.setDesciption("The stream doesn't support seeking.");
            seekFailed.setLevel("error");
            Channel channel = ((RTMPConnection)streamConn).getChannel((byte)(4 + (streamId - 1) * 5));
            channel.sendStatus(seekFailed);
        }
    }

    public void receiveVideo(boolean receive) {
        IConnection conn = Red5.getConnectionLocal();
        if (!(conn instanceof IStreamCapableConnection)) {
            return;
        }
        IStreamCapableConnection streamConn = (IStreamCapableConnection)conn;
        int streamId = this.getCurrentStreamId();
        IClientStream stream = streamConn.getStreamById(streamId);
        if (stream == null || !(stream instanceof ISubscriberStream)) {
            return;
        }
        ISubscriberStream subscriberStream = (ISubscriberStream)stream;
        subscriberStream.receiveVideo(receive);
    }

    public void receiveAudio(boolean receive) {
        IConnection conn = Red5.getConnectionLocal();
        if (!(conn instanceof IStreamCapableConnection)) {
            return;
        }
        IStreamCapableConnection streamConn = (IStreamCapableConnection)conn;
        int streamId = this.getCurrentStreamId();
        IClientStream stream = streamConn.getStreamById(streamId);
        if (stream == null || !(stream instanceof ISubscriberStream)) {
            return;
        }
        ISubscriberStream subscriberStream = (ISubscriberStream)stream;
        subscriberStream.receiveAudio(receive);
    }

    private int getCurrentStreamId() {
        return BaseRTMPHandler.getStreamId();
    }

    public IBroadcastScope getBroadcastScope(IScope scope, String name) {
        IBasicScope basicScope = scope.getBasicScope("bs", name);
        if (!(basicScope instanceof IBroadcastScope)) {
            return null;
        }
        return (IBroadcastScope)basicScope;
    }

    private void sendNSFailed(RTMPConnection conn, String description, String name, int streamId) {
        Status failed = new Status("NetStream.Failed");
        failed.setClientid(streamId);
        failed.setDesciption(description);
        failed.setDetails(name);
        failed.setLevel("error");
        Channel channel = conn.getChannel((byte)(4 + (streamId - 1) * 5));
        channel.sendStatus(failed);
    }
}

