/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.ByteBuffer;
import org.red5.server.api.stream.IVideoStreamCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoCodecFactory {
    public static final String KEY = "videoCodecFactory";
    private Logger log = LoggerFactory.getLogger(VideoCodecFactory.class);
    private List<IVideoStreamCodec> codecs = new ArrayList<IVideoStreamCodec>();

    public void setCodecs(List<IVideoStreamCodec> codecs) {
        this.codecs = codecs;
    }

    public IVideoStreamCodec getVideoCodec(ByteBuffer data) {
        IVideoStreamCodec result = null;
        for (IVideoStreamCodec storedCodec : this.codecs) {
            IVideoStreamCodec codec;
            try {
                codec = (IVideoStreamCodec)storedCodec.getClass().newInstance();
            }
            catch (Exception e) {
                this.log.error("Could not create video codec instance.", (Throwable)e);
                continue;
            }
            this.log.info("Trying codec " + codec);
            if (!codec.canHandleData(data)) continue;
            result = codec;
            break;
        }
        return result;
    }
}

