/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.codec;

import org.apache.mina.common.ByteBuffer;
import org.red5.server.api.stream.IVideoStreamCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenVideo
implements IVideoStreamCodec {
    private Logger log = LoggerFactory.getLogger(ScreenVideo.class);
    static final String CODEC_NAME = "ScreenVideo";
    static final byte FLV_FRAME_KEY = 16;
    static final byte FLV_CODEC_SCREEN = 3;
    private byte[] blockData;
    private int[] blockSize;
    private int width;
    private int height;
    private int widthInfo;
    private int heightInfo;
    private int blockWidth;
    private int blockHeight;
    private int blockCount;
    private int blockDataSize;
    private int totalBlockDataSize;

    public ScreenVideo() {
        this.reset();
    }

    public String getName() {
        return CODEC_NAME;
    }

    public void reset() {
        this.blockData = null;
        this.blockSize = null;
        this.width = 0;
        this.height = 0;
        this.widthInfo = 0;
        this.heightInfo = 0;
        this.blockWidth = 0;
        this.blockHeight = 0;
        this.blockCount = 0;
        this.blockDataSize = 0;
        this.totalBlockDataSize = 0;
    }

    public boolean canHandleData(ByteBuffer data) {
        byte first = data.get();
        boolean result = (first & 0xF) == 3;
        data.rewind();
        return result;
    }

    public boolean canDropFrames() {
        return false;
    }

    private int maxCompressedSize(int size) {
        return size + (size >> 12) + (size >> 14) + 11;
    }

    private void updateSize(ByteBuffer data) {
        this.widthInfo = data.getShort();
        this.heightInfo = data.getShort();
        this.width = this.widthInfo & 0xFFF;
        this.height = this.heightInfo & 0xFFF;
        this.blockWidth = this.widthInfo & 0xF000;
        this.blockWidth = (this.blockWidth >> 12) + 1;
        this.blockWidth <<= 4;
        this.blockHeight = this.heightInfo & 0xF000;
        this.blockHeight = (this.blockHeight >> 12) + 1;
        this.blockHeight <<= 4;
        int xblocks = this.width / this.blockWidth;
        if (this.width % this.blockWidth != 0) {
            ++xblocks;
        }
        int yblocks = this.height / this.blockHeight;
        if (this.height % this.blockHeight != 0) {
            ++yblocks;
        }
        this.blockCount = xblocks * yblocks;
        int blockSize = this.maxCompressedSize(this.blockWidth * this.blockHeight * 3);
        int totalBlockSize = blockSize * this.blockCount;
        if (this.totalBlockDataSize != totalBlockSize) {
            this.log.info("Allocating memory for " + this.blockCount + " compressed blocks.");
            this.blockDataSize = blockSize;
            this.totalBlockDataSize = totalBlockSize;
            this.blockData = new byte[blockSize * this.blockCount];
            this.blockSize = new int[blockSize * this.blockCount];
            for (int idx = 0; idx < this.blockCount; ++idx) {
                this.blockSize[idx] = 0;
            }
        }
    }

    public boolean addData(ByteBuffer data) {
        if (!this.canHandleData(data)) {
            return false;
        }
        data.get();
        this.updateSize(data);
        int idx = 0;
        int pos = 0;
        byte[] tmpData = new byte[this.blockDataSize];
        for (int countBlocks = this.blockCount; data.remaining() > 0 && countBlocks > 0; --countBlocks) {
            short size = data.getShort();
            if (size == 0) {
                ++idx;
                pos += this.blockDataSize;
                continue;
            }
            this.blockSize[idx] = size;
            data.get(tmpData, 0, (int)size);
            System.arraycopy(tmpData, 0, this.blockData, pos, size);
            ++idx;
            pos += this.blockDataSize;
        }
        data.rewind();
        return true;
    }

    public ByteBuffer getKeyframe() {
        ByteBuffer result = ByteBuffer.allocate((int)1024);
        result.setAutoExpand(true);
        result.put((byte)19);
        result.putShort((short)this.widthInfo);
        result.putShort((short)this.heightInfo);
        byte[] tmpData = new byte[this.blockDataSize];
        int pos = 0;
        for (int idx = 0; idx < this.blockCount; ++idx) {
            int size = this.blockSize[idx];
            if (size == 0) {
                return null;
            }
            result.putShort((short)size);
            System.arraycopy(this.blockData, pos, tmpData, 0, size);
            result.put(tmpData, 0, size);
            pos += this.blockDataSize;
        }
        result.rewind();
        return result;
    }
}

