/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.consumer;

import org.red5.server.api.IBWControllable;
import org.red5.server.api.IBandwidthConfigure;
import org.red5.server.api.IConnectionBWConfig;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IPushableConsumer;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.BytesRead;
import org.red5.server.net.rtmp.event.ChunkSize;
import org.red5.server.net.rtmp.event.FlexStreamSend;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.stream.StreamTracker;
import org.red5.server.stream.message.RTMPMessage;
import org.red5.server.stream.message.ResetMessage;
import org.red5.server.stream.message.StatusMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConsumer
implements IPushableConsumer,
IPipeConnectionListener {
    private static final Logger log = LoggerFactory.getLogger(ConnectionConsumer.class);
    public static final String KEY = ConnectionConsumer.class.getName();
    private RTMPConnection conn;
    private Channel video;
    private Channel audio;
    private Channel data;
    private int chunkSize = -1;
    private StreamTracker streamTracker;

    public ConnectionConsumer(RTMPConnection conn, int videoChannel, int audioChannel, int dataChannel) {
        this.conn = conn;
        this.video = conn.getChannel(videoChannel);
        this.audio = conn.getChannel(audioChannel);
        this.data = conn.getChannel(dataChannel);
        this.streamTracker = new StreamTracker();
    }

    public void pushMessage(IPipe pipe, IMessage message) {
        if (message instanceof ResetMessage) {
            this.streamTracker.reset();
        } else if (message instanceof StatusMessage) {
            StatusMessage statusMsg = (StatusMessage)message;
            this.data.sendStatus(statusMsg.getBody());
        } else if (message instanceof RTMPMessage) {
            RTMPMessage rtmpMsg = (RTMPMessage)message;
            IRTMPEvent msg = rtmpMsg.getBody();
            Header header = new Header();
            int timestamp = this.streamTracker.add(msg);
            if (timestamp < 0) {
                log.warn("Skipping message with negative timestamp.");
                return;
            }
            header.setTimerRelative(this.streamTracker.isRelative());
            header.setTimer(timestamp);
            switch (msg.getDataType()) {
                case 18: {
                    Notify notify = new Notify(((Notify)msg).getData().asReadOnlyBuffer());
                    notify.setHeader(header);
                    notify.setTimestamp(header.getTimer());
                    this.data.write(notify);
                    break;
                }
                case 15: {
                    FlexStreamSend send = new FlexStreamSend(((Notify)msg).getData().asReadOnlyBuffer());
                    send.setHeader(header);
                    send.setTimestamp(header.getTimer());
                    this.data.write(send);
                    break;
                }
                case 9: {
                    VideoData videoData = new VideoData(((VideoData)msg).getData().asReadOnlyBuffer());
                    videoData.setHeader(header);
                    videoData.setTimestamp(header.getTimer());
                    this.video.write(videoData);
                    break;
                }
                case 8: {
                    AudioData audioData = new AudioData(((AudioData)msg).getData().asReadOnlyBuffer());
                    audioData.setHeader(header);
                    audioData.setTimestamp(header.getTimer());
                    this.audio.write(audioData);
                    break;
                }
                case 4: {
                    Ping ping = new Ping(((Ping)msg).getValue1(), ((Ping)msg).getValue2(), ((Ping)msg).getValue3(), ((Ping)msg).getValue4());
                    header.setTimerRelative(false);
                    header.setTimer(0);
                    ping.setHeader(header);
                    ping.setTimestamp(header.getTimer());
                    this.conn.ping(ping);
                    break;
                }
                case 3: {
                    BytesRead bytesRead = new BytesRead(((BytesRead)msg).getBytesRead());
                    header.setTimerRelative(false);
                    header.setTimer(0);
                    bytesRead.setHeader(header);
                    bytesRead.setTimestamp(header.getTimer());
                    this.conn.getChannel(2).write(bytesRead);
                    break;
                }
                default: {
                    this.data.write(msg);
                }
            }
        }
    }

    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        switch (event.getType()) {
            case 2: {
                this.conn.closeChannel(this.video.getId());
                this.conn.closeChannel(this.audio.getId());
                this.conn.closeChannel(this.data.getId());
                break;
            }
        }
    }

    public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
        int newSize;
        if (!"ConnectionConsumer".equals(oobCtrlMsg.getTarget())) {
            return;
        }
        if ("pendingCount".equals(oobCtrlMsg.getServiceName())) {
            oobCtrlMsg.setResult(this.conn.getPendingMessages());
        } else if ("pendingVideoCount".equals(oobCtrlMsg.getServiceName())) {
            IClientStream stream = this.conn.getStreamByChannelId(this.video.getId());
            if (stream != null) {
                oobCtrlMsg.setResult(this.conn.getPendingVideoMessages(stream.getStreamId()));
            } else {
                oobCtrlMsg.setResult(0L);
            }
        } else if ("writeDelta".equals(oobCtrlMsg.getServiceName())) {
            IBandwidthConfigure bwc;
            IBWControllable bwControllable;
            long maxStream = 0L;
            for (bwControllable = this.conn; bwControllable != null && bwControllable.getBandwidthConfigure() == null; bwControllable = bwControllable.getParentBWControllable()) {
            }
            if (bwControllable != null && bwControllable.getBandwidthConfigure() != null && (bwc = bwControllable.getBandwidthConfigure()) instanceof IConnectionBWConfig) {
                maxStream = ((IConnectionBWConfig)bwc).getDownstreamBandwidth() / 8L;
            }
            if (maxStream <= 0L) {
                maxStream = 122880L;
            }
            oobCtrlMsg.setResult(new Long[]{this.conn.getWrittenBytes() - this.conn.getClientBytesRead(), maxStream / 2L});
        } else if ("chunkSize".equals(oobCtrlMsg.getServiceName()) && (newSize = ((Integer)oobCtrlMsg.getServiceParamMap().get("chunkSize")).intValue()) != this.chunkSize) {
            this.chunkSize = newSize;
            ChunkSize chunkSizeMsg = new ChunkSize(this.chunkSize);
            this.conn.getChannel(2).write(chunkSizeMsg);
        }
    }
}

