/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.consumer;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.IStreamableFile;
import org.red5.io.IStreamableFileFactory;
import org.red5.io.IStreamableFileService;
import org.red5.io.ITagWriter;
import org.red5.io.StreamableFileFactory;
import org.red5.io.flv.impl.Tag;
import org.red5.server.api.IScope;
import org.red5.server.api.ScopeUtils;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IPushableConsumer;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.stream.IStreamData;
import org.red5.server.stream.message.RTMPMessage;
import org.red5.server.stream.message.ResetMessage;
import org.red5.server.stream.message.StatusMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConsumer
implements Constants,
IPushableConsumer,
IPipeConnectionListener {
    private static final Logger log = LoggerFactory.getLogger(FileConsumer.class);
    private IScope scope;
    private File file;
    private ITagWriter writer;
    private String mode;
    private int offset;
    private int lastTimestamp;
    private int startTimestamp;

    public FileConsumer(IScope scope, File file) {
        this.scope = scope;
        this.file = file;
        this.offset = 0;
        this.lastTimestamp = 0;
        this.startTimestamp = -1;
    }

    public void pushMessage(IPipe pipe, IMessage message) throws IOException {
        int timestamp;
        if (message instanceof ResetMessage) {
            this.startTimestamp = -1;
            this.offset += this.lastTimestamp;
            return;
        }
        if (message instanceof StatusMessage) {
            return;
        }
        if (!(message instanceof RTMPMessage)) {
            return;
        }
        if (this.writer == null) {
            this.init();
        }
        RTMPMessage rtmpMsg = (RTMPMessage)message;
        IRTMPEvent msg = rtmpMsg.getBody();
        if (this.startTimestamp == -1) {
            this.startTimestamp = msg.getTimestamp();
        }
        if ((timestamp = msg.getTimestamp() - this.startTimestamp) < 0) {
            log.warn("Skipping message with negative timestamp.");
            return;
        }
        this.lastTimestamp = timestamp;
        Tag tag = new Tag();
        tag.setDataType(msg.getDataType());
        tag.setTimestamp(timestamp + this.offset);
        if (msg instanceof IStreamData) {
            ByteBuffer data = ((IStreamData)((Object)msg)).getData().asReadOnlyBuffer();
            tag.setBodySize(data.limit());
            tag.setBody(data);
        }
        try {
            this.writer.writeTag(tag);
        }
        catch (IOException e) {
            log.error("error writing tag", (Throwable)e);
        }
    }

    public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
    }

    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        switch (event.getType()) {
            case 4: {
                Map paramMap;
                if (event.getConsumer() != this || (paramMap = event.getParamMap()) == null) break;
                this.mode = (String)paramMap.get("mode");
                break;
            }
            case 5: {
                if (event.getConsumer() != this) break;
            }
            case 2: {
                this.uninit();
                break;
            }
        }
    }

    private void init() throws IOException {
        IStreamableFileFactory factory = (IStreamableFileFactory)ScopeUtils.getScopeService(this.scope, IStreamableFileFactory.class, StreamableFileFactory.class);
        File folder = this.file.getParentFile();
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IOException("can't create parent folder");
        }
        if (!this.file.isFile()) {
            this.file.createNewFile();
        } else if (!this.file.canWrite()) {
            throw new IOException("the file is read-only");
        }
        IStreamableFileService service = factory.getService(this.file);
        IStreamableFile flv = service.getStreamableFile(this.file);
        if (this.mode == null || this.mode.equals("record")) {
            this.writer = flv.getWriter();
        } else if (this.mode.equals("append")) {
            this.writer = flv.getAppendWriter();
        } else {
            throw new IllegalStateException("illegal mode type: " + this.mode);
        }
    }

    private synchronized void uninit() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }
}

