/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.provider;

import java.io.File;
import java.io.IOException;
import org.red5.io.IStreamableFile;
import org.red5.io.IStreamableFileFactory;
import org.red5.io.IStreamableFileService;
import org.red5.io.ITag;
import org.red5.io.ITagReader;
import org.red5.io.StreamableFileFactory;
import org.red5.io.flv.IKeyFrameDataAnalyzer;
import org.red5.server.api.IScope;
import org.red5.server.api.ScopeUtils;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IPassive;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IPullableProvider;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Unknown;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.stream.ISeekableProvider;
import org.red5.server.stream.IStreamTypeAwareProvider;
import org.red5.server.stream.message.RTMPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProvider
implements IPassive,
ISeekableProvider,
IPullableProvider,
IPipeConnectionListener,
IStreamTypeAwareProvider {
    private static final Logger log = LoggerFactory.getLogger(FileProvider.class);
    public static final String KEY = FileProvider.class.getName();
    private IScope scope;
    private File file;
    private IPipe pipe;
    private ITagReader reader;
    private IKeyFrameDataAnalyzer.KeyFrameMeta keyFrameMeta;
    private int start;

    public FileProvider(IScope scope, File file) {
        this.scope = scope;
        this.file = file;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public boolean hasVideo() {
        return this.reader != null && this.reader.hasVideo();
    }

    public synchronized IMessage pullMessage(IPipe pipe) throws IOException {
        if (this.pipe != pipe) {
            return null;
        }
        if (this.reader == null) {
            this.init();
        }
        if (!this.reader.hasMoreTags()) {
            return null;
        }
        ITag tag = this.reader.readTag();
        BaseEvent msg = null;
        int timestamp = tag.getTimestamp();
        switch (tag.getDataType()) {
            case 8: {
                msg = new AudioData(tag.getBody());
                break;
            }
            case 9: {
                msg = new VideoData(tag.getBody());
                break;
            }
            case 20: {
                msg = new Invoke(tag.getBody());
                break;
            }
            case 18: {
                msg = new Notify(tag.getBody());
                break;
            }
            default: {
                log.warn("Unexpected type? " + tag.getDataType());
                msg = new Unknown(tag.getDataType(), tag.getBody());
            }
        }
        msg.setTimestamp(timestamp);
        RTMPMessage rtmpMsg = new RTMPMessage();
        rtmpMsg.setBody(msg);
        return rtmpMsg;
    }

    public IMessage pullMessage(IPipe pipe, long wait) throws IOException {
        return this.pullMessage(pipe);
    }

    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        switch (event.getType()) {
            case 0: {
                if (this.pipe != null) break;
                this.pipe = (IPipe)event.getSource();
                break;
            }
            case 2: {
                if (this.pipe != event.getSource()) break;
                this.pipe = null;
                this.uninit();
                break;
            }
            case 5: {
                if (this.pipe != event.getSource()) break;
                this.uninit();
            }
        }
    }

    public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
        if (IPassive.KEY.equals(oobCtrlMsg.getTarget())) {
            if (oobCtrlMsg.getServiceName().equals("init")) {
                Integer startTS = (Integer)oobCtrlMsg.getServiceParamMap().get("startTS");
                this.setStart(startTS);
            }
        } else if (ISeekableProvider.KEY.equals(oobCtrlMsg.getTarget())) {
            if (oobCtrlMsg.getServiceName().equals("seek")) {
                Integer position = (Integer)oobCtrlMsg.getServiceParamMap().get("position");
                int seekPos = this.seek(position);
                oobCtrlMsg.setResult(seekPos);
            }
        } else if (IStreamTypeAwareProvider.KEY.equals(oobCtrlMsg.getTarget()) && oobCtrlMsg.getServiceName().equals("hasVideo")) {
            oobCtrlMsg.setResult(this.hasVideo());
        }
    }

    private void init() throws IOException {
        IStreamableFileFactory factory = (IStreamableFileFactory)ScopeUtils.getScopeService(this.scope, IStreamableFileFactory.class, StreamableFileFactory.class);
        IStreamableFileService service = factory.getService(this.file);
        if (service == null) {
            log.error("No service found for " + this.file.getAbsolutePath());
            return;
        }
        IStreamableFile streamFile = service.getStreamableFile(this.file);
        this.reader = streamFile.getReader();
        if (this.start > 0) {
            this.seek(this.start);
        }
    }

    private synchronized void uninit() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public synchronized int seek(int ts) {
        if (this.keyFrameMeta == null) {
            if (!(this.reader instanceof IKeyFrameDataAnalyzer)) {
                return ts;
            }
            this.keyFrameMeta = ((IKeyFrameDataAnalyzer)((Object)this.reader)).analyzeKeyFrames();
        }
        if (this.keyFrameMeta.positions.length == 0) {
            return ts;
        }
        if ((long)ts >= this.keyFrameMeta.duration) {
            this.reader.position(Long.MAX_VALUE);
            return (int)this.keyFrameMeta.duration;
        }
        int frame = 0;
        int i = 0;
        while (i < this.keyFrameMeta.positions.length && this.keyFrameMeta.timestamps[i] <= ts) {
            frame = i++;
        }
        this.reader.position(this.keyFrameMeta.positions[frame]);
        return this.keyFrameMeta.timestamps[frame];
    }
}

