/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.tomcat;

import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.startup.Embedded;
import org.red5.server.LoaderBase;
import org.red5.server.api.IApplicationLoader;
import org.red5.server.tomcat.TomcatApplicationContext;
import org.springframework.context.ApplicationContext;

public class TomcatApplicationLoader
implements IApplicationLoader {
    private Embedded embedded;
    private Host host;
    private ApplicationContext rootCtx;

    protected TomcatApplicationLoader(Embedded embedded, Host host, ApplicationContext rootCtx) {
        this.embedded = embedded;
        this.host = host;
        this.rootCtx = rootCtx;
    }

    public ApplicationContext getRootContext() {
        return this.rootCtx;
    }

    public void loadApplication(String contextPath, String virtualHosts, String directory) throws Exception {
        if (directory.startsWith("file:")) {
            directory = directory.substring(5);
        }
        Context c = this.embedded.createContext(contextPath, directory);
        LoaderBase.setRed5ApplicationContext(contextPath, new TomcatApplicationContext(c));
        this.host.addChild((Container)c);
    }
}

