/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.war;

import java.beans.Introspector;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang.StringUtils;
import org.red5.server.jmx.JMXAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class MainServlet
extends HttpServlet
implements ServletContextListener {
    private static final long serialVersionUID = 41919712006L;
    public static Logger logger = LoggerFactory.getLogger(MainServlet.class);
    protected static String red5Config = "/WEB-INF/applicationContext.xml";
    private static ServletContext servletContext;

    public void contextInitialized(ServletContextEvent sce) {
        System.setProperty("red5.deployment.type", "war");
        if (null != servletContext) {
            return;
        }
        servletContext = sce.getServletContext();
        String prefix = servletContext.getRealPath("/");
        long time = System.currentTimeMillis();
        logger.info("RED5 Server (http://www.osflash.org/red5)");
        logger.info("Loading red5 global context from: " + red5Config);
        logger.info("Path: " + prefix);
        try {
            String classpath = System.getProperty("java.class.path");
            File fp = new File(prefix + red5Config);
            fp = fp.getCanonicalFile();
            if (!fp.isFile()) {
                String[] paths;
                for (String element : paths = classpath.split(System.getProperty("path.separator"))) {
                    fp = new File(element + "/" + red5Config);
                    if ((fp = fp.getCanonicalFile()).isFile()) break;
                }
            }
            if (!fp.isFile()) {
                throw new Exception("could not find configuration file " + red5Config + " on your classpath " + classpath);
            }
            String root = fp.getAbsolutePath();
            root = root.replace('\\', '/');
            int idx = root.lastIndexOf(47);
            root = root.substring(0, idx);
            System.setProperty("java.class.path", classpath + File.pathSeparatorChar + root + File.pathSeparatorChar + root + "/classes");
            logger.debug("New classpath: " + System.getProperty("java.class.path"));
            System.setProperty("red5.config_root", root);
            logger.info("Setting configuation root to " + root);
            Properties props = new Properties();
            props.load(new FileInputStream(root + "/red5.properties"));
            for (Object o : props.keySet()) {
                String key = (String)o;
                if (!StringUtils.isNotBlank((String)key)) continue;
                System.setProperty(key, props.getProperty(key));
            }
            idx = root.lastIndexOf(47);
            root = root.substring(0, idx);
            if (System.getProperty("file.separator").equals("/")) {
                root = "/" + root;
            }
            System.setProperty("red5.root", root);
            logger.info("Setting Red5 root to " + root);
            Class<XmlWebApplicationContext> contextClass = XmlWebApplicationContext.class;
            ConfigurableWebApplicationContext applicationContext = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass(contextClass);
            String[] strArray = servletContext.getInitParameter("contextConfigLocation").split("[,\\s]");
            logger.info("Config location files: " + strArray.length);
            applicationContext.setConfigLocations(strArray);
            applicationContext.setServletContext(servletContext);
            applicationContext.refresh();
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)applicationContext);
            ConfigurableListableBeanFactory factory = applicationContext.getBeanFactory();
            factory.registerSingleton("default.context", (Object)applicationContext);
        }
        catch (Throwable e) {
            logger.error("", e);
        }
        long startupIn = System.currentTimeMillis() - time;
        logger.info("Startup done in: " + startupIn + " ms");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        logger.info("Webapp shutdown");
        try {
            Introspector.flushCaches();
            Enumeration<Driver> e = DriverManager.getDrivers();
            while (e.hasMoreElements()) {
                Driver driver = e.nextElement();
                if (driver.getClass().getClassLoader() != ((Object)((Object)this)).getClass().getClassLoader()) continue;
                DriverManager.deregisterDriver(driver);
            }
            JMXAgent.shutdown();
            ConfigurableWebApplicationContext applicationContext = (ConfigurableWebApplicationContext)servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            ConfigurableListableBeanFactory factory = applicationContext.getBeanFactory();
            if (factory.containsSingleton("default.context")) {
                for (String scope : factory.getRegisteredScopeNames()) {
                    logger.debug("Registered scope: " + scope);
                }
                for (String singleton : factory.getSingletonNames()) {
                    logger.debug("Registered singleton: " + singleton);
                }
                factory.destroySingletons();
            }
            servletContext.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            applicationContext.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

