/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.war;

import java.beans.Introspector;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.red5.server.ClientRegistry;
import org.red5.server.Context;
import org.red5.server.GlobalScope;
import org.red5.server.MappingStrategy;
import org.red5.server.ScopeResolver;
import org.red5.server.Server;
import org.red5.server.WebScope;
import org.red5.server.jmx.JMXAgent;
import org.red5.server.service.ServiceInvoker;
import org.red5.server.war.IRemotableList;
import org.red5.server.war.WebSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextBeanFactoryReference;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class RootContextLoaderServlet
extends ContextLoaderListener {
    private static final long serialVersionUID = 41919712007L;
    private static ClassLoader myClassloader;
    public static Logger logger;
    private static Timer timer;
    private CheckScopeListTask checkScopeList;
    private static ArrayList<ServletContext> registeredContexts;
    private ConfigurableWebApplicationContext applicationContext;
    private DefaultListableBeanFactory parentFactory;
    private static ServletContext servletContext;
    private static RootContextLoaderServlet instance;
    private ClientRegistry clientRegistry;
    private ServiceInvoker globalInvoker;
    private MappingStrategy globalStrategy;
    private ScopeResolver globalResolver;
    private GlobalScope global;
    private Server server;
    protected Integer rmiPort = 1099;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        if (null != servletContext) {
            return;
        }
        instance = this;
        System.setProperty("red5.deployment.type", "war");
        myClassloader = ((Object)((Object)this)).getClass().getClassLoader();
        servletContext = sce.getServletContext();
        String prefix = servletContext.getRealPath("/");
        servletContext.setAttribute("root.classloader", (Object)myClassloader);
        this.initRegistry(servletContext);
        long time = System.currentTimeMillis();
        logger.info("RED5 Server (http://www.osflash.org/red5)");
        logger.info("Root context loader");
        logger.debug("Path: " + prefix);
        try {
            ContextLoader loader = this.createContextLoader();
            this.applicationContext = (ConfigurableWebApplicationContext)loader.initWebApplicationContext(servletContext);
            logger.debug("Root context path: " + this.applicationContext.getServletContext().getContextPath());
            ConfigurableListableBeanFactory factory = this.applicationContext.getBeanFactory();
            factory.registerSingleton("default.context", (Object)this.applicationContext);
            this.parentFactory = (DefaultListableBeanFactory)factory.getParentBeanFactory();
            ContextBeanFactoryReference beanfactoryRef = new ContextBeanFactoryReference((ApplicationContext)this.applicationContext);
            servletContext.setAttribute("bean.factory.ref", (Object)beanfactoryRef);
            servletContext.setAttribute("remoting.codec.factory", this.parentFactory.getBean("remotingCodecFactory"));
            this.server = (Server)this.parentFactory.getBean("red5.server");
            this.clientRegistry = (ClientRegistry)factory.getBean("global.clientRegistry");
            this.globalInvoker = (ServiceInvoker)factory.getBean("global.serviceInvoker");
            this.globalStrategy = (MappingStrategy)factory.getBean("global.mappingStrategy");
            this.global = (GlobalScope)factory.getBean("global.scope");
            logger.debug("GlobalScope: " + this.global);
            this.global.setServer(this.server);
            this.global.register();
            this.global.start();
            this.globalResolver = new ScopeResolver();
            this.globalResolver.setGlobalScope(this.global);
            logger.debug("About to grab Webcontext bean for Global");
            Context globalContext = (Context)factory.getBean("global.context");
            globalContext.setCoreBeanFactory((BeanFactory)this.parentFactory);
            globalContext.setClientRegistry(this.clientRegistry);
            globalContext.setServiceInvoker(this.globalInvoker);
            globalContext.setScopeResolver(this.globalResolver);
            globalContext.setMappingStrategy(this.globalStrategy);
            logger.debug("About to grab Webcontext bean for ROOT");
            Context webContext = (Context)factory.getBean("web.context");
            webContext.setCoreBeanFactory((BeanFactory)this.parentFactory);
            webContext.setClientRegistry(this.clientRegistry);
            webContext.setServiceInvoker(this.globalInvoker);
            webContext.setScopeResolver(this.globalResolver);
            webContext.setMappingStrategy(this.globalStrategy);
            WebScope scope = (WebScope)factory.getBean("web.scope");
            scope.setServer(this.server);
            scope.setParent(this.global);
            scope.register();
            scope.start();
            IRemotableList remote = (IRemotableList)Naming.lookup("rmi://localhost:" + this.rmiPort + "/subContextList");
            logger.debug("Children: " + remote.numChildren());
            if (remote.hasChildren()) {
                logger.debug("Children were detected");
                for (int i = 0; i < remote.numChildren(); ++i) {
                    logger.debug("Enumerating children");
                    WebSettings settings = remote.getAt(i);
                    this.registerSubContext(settings.getWebAppKey());
                }
                logger.debug("End of children...");
            }
        }
        catch (Throwable t) {
            logger.error("", t);
        }
        finally {
            timer = new Timer();
            this.checkScopeList = new CheckScopeListTask();
            timer.scheduleAtFixedRate((TimerTask)this.checkScopeList, 1000L, 30000L);
        }
        long startupIn = System.currentTimeMillis() - time;
        logger.info("Startup done in: " + startupIn + " ms");
    }

    public void registerSubContext(String webAppKey) {
        ServletContext ctx = servletContext.getContext(webAppKey);
        logger.info("Registering subcontext for servlet context: " + ctx.getContextPath());
        if (registeredContexts.contains(ctx)) {
            logger.debug("Context is already registered: " + webAppKey);
            return;
        }
        ContextLoader loader = new ContextLoader();
        ConfigurableWebApplicationContext appCtx = (ConfigurableWebApplicationContext)loader.initWebApplicationContext(ctx);
        appCtx.setParent((ApplicationContext)this.applicationContext);
        appCtx.refresh();
        ctx.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)appCtx);
        ConfigurableListableBeanFactory appFactory = appCtx.getBeanFactory();
        logger.debug("About to grab Webcontext bean for " + webAppKey);
        Context webContext = (Context)appCtx.getBean("web.context");
        webContext.setCoreBeanFactory((BeanFactory)this.parentFactory);
        webContext.setClientRegistry(this.clientRegistry);
        webContext.setServiceInvoker(this.globalInvoker);
        webContext.setScopeResolver(this.globalResolver);
        webContext.setMappingStrategy(this.globalStrategy);
        WebScope scope = (WebScope)appFactory.getBean("web.scope");
        scope.setServer(this.server);
        scope.setParent(this.global);
        scope.register();
        scope.start();
        registeredContexts.add(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        RootContextLoaderServlet rootContextLoaderServlet = instance;
        synchronized (rootContextLoaderServlet) {
            logger.info("Webapp shutdown");
            try {
                ServletContext ctx = sce.getServletContext();
                if (ctx.getContextPath().equals("/ROOT")) {
                    timer.cancel();
                } else {
                    registeredContexts.remove(ctx);
                }
                Introspector.flushCaches();
                Enumeration<Driver> e = DriverManager.getDrivers();
                while (e.hasMoreElements()) {
                    Driver driver = e.nextElement();
                    if (driver.getClass().getClassLoader() != ((Object)((Object)this)).getClass().getClassLoader()) continue;
                    DriverManager.deregisterDriver(driver);
                }
                JMXAgent.shutdown();
                Object attr = ctx.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
                if (attr != null) {
                    ConfigurableWebApplicationContext applicationContext = (ConfigurableWebApplicationContext)attr;
                    ConfigurableListableBeanFactory factory = applicationContext.getBeanFactory();
                    try {
                        for (String singleton : factory.getSingletonNames()) {
                            logger.debug("Registered singleton: " + singleton);
                            factory.destroyScopedBean(singleton);
                        }
                    }
                    catch (RuntimeException e2) {
                        // empty catch block
                    }
                    factory.destroySingletons();
                    ctx.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
                    applicationContext.close();
                }
                instance.getContextLoader().closeWebApplicationContext(ctx);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected void initRegistry(ServletContext ctx) {
        Registry r = null;
        try {
            String o = ctx.getInitParameter("rmiPort");
            if (o != null) {
                this.rmiPort = Integer.valueOf(o);
            }
            if (System.getSecurityManager() != null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            r = LocateRegistry.getRegistry(this.rmiPort);
            for (String regName : r.list()) {
                logger.debug("Registry entry: " + regName);
            }
        }
        catch (RemoteException re) {
            logger.info("RMI Registry server was not found on port " + this.rmiPort);
            try {
                logger.info("Starting an internal RMI registry");
                r = LocateRegistry.createRegistry(this.rmiPort);
            }
            catch (RemoteException e) {
                logger.info("RMI Registry server was not started on port " + this.rmiPort);
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(RootContextLoaderServlet.class);
        registeredContexts = new ArrayList(3);
    }

    public final class CheckScopeListTask
    extends TimerTask {
        public void run() {
            logger.debug("Checking scope list");
            try {
                IRemotableList remote = (IRemotableList)Naming.lookup("rmi://localhost:" + RootContextLoaderServlet.this.rmiPort + "/subContextList");
                logger.debug("Children: " + remote.numChildren());
                if (remote.hasChildren()) {
                    logger.debug("Children were detected");
                    for (int i = 0; i < remote.numChildren(); ++i) {
                        logger.debug("Enumerating children");
                        WebSettings settings = remote.getAt(i);
                        RootContextLoaderServlet.this.registerSubContext(settings.getWebAppKey());
                    }
                    logger.debug("End of children...");
                }
            }
            catch (Throwable t) {
                logger.error("", t);
            }
        }
    }
}

