/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.war;

import java.rmi.Naming;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.red5.server.war.IRemotableList;
import org.red5.server.war.RemotableList;
import org.red5.server.war.RootContextLoaderServlet;
import org.red5.server.war.WebSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubContextLoaderServlet
extends RootContextLoaderServlet {
    private static final long serialVersionUID = 41919712007L;
    public static Logger logger = LoggerFactory.getLogger(SubContextLoaderServlet.class);
    private static ServletContext servletContext;

    public void contextInitialized(ServletContextEvent sce) {
        if (null != servletContext) {
            return;
        }
        System.setProperty("red5.deployment.type", "war");
        servletContext = sce.getServletContext();
        String prefix = servletContext.getRealPath("/");
        this.initRegistry(servletContext);
        long time = System.currentTimeMillis();
        logger.info("RED5 Server subcontext loader");
        logger.debug("Path: " + prefix);
        try {
            String[] configArray = servletContext.getInitParameter("contextConfigLocation").split("[,\\s]");
            logger.debug("Config location files: " + configArray.length);
            WebSettings settings = new WebSettings();
            settings.setPath(prefix);
            String[] subConfigs = new String[configArray.length];
            for (int s = 0; s < configArray.length; ++s) {
                String cfg = "file:/" + prefix + configArray[s];
                logger.debug("Sub config location: " + cfg);
                subConfigs[s] = cfg;
            }
            settings.setConfigs(subConfigs);
            settings.setWebAppKey(servletContext.getInitParameter("webAppRootKey"));
            IRemotableList remote = null;
            boolean firstReg = false;
            try {
                remote = (IRemotableList)Naming.lookup("rmi://localhost:" + this.rmiPort + "/subContextList");
            }
            catch (Exception e) {
                logger.warn("Lookup failed: " + e.getMessage());
            }
            if (remote == null) {
                remote = new RemotableList();
                firstReg = true;
            }
            logger.debug("Adding child web settings");
            remote.addChild(settings);
            logger.debug("Remote list size: " + remote.numChildren());
            if (firstReg) {
                Naming.bind("rmi://localhost:" + this.rmiPort + "/subContextList", remote);
            } else {
                Naming.rebind("rmi://localhost:" + this.rmiPort + "/subContextList", remote);
            }
        }
        catch (Throwable t) {
            logger.error("", t);
        }
        long startupIn = System.currentTimeMillis() - time;
        logger.info("Startup done in: " + startupIn + " ms");
    }
}

