/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.war;

import java.beans.Introspector;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.red5.server.ClientRegistry;
import org.red5.server.Context;
import org.red5.server.GlobalScope;
import org.red5.server.MappingStrategy;
import org.red5.server.ScopeResolver;
import org.red5.server.Server;
import org.red5.server.WebScope;
import org.red5.server.jmx.JMXAgent;
import org.red5.server.persistence.FilePersistenceThread;
import org.red5.server.service.ServiceInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class WarLoaderServlet
extends ContextLoaderListener {
    private static final long serialVersionUID = 41919712008L;
    public static Logger logger = LoggerFactory.getLogger(WarLoaderServlet.class);
    private static ArrayList<ServletContext> registeredContexts = new ArrayList(3);
    private ConfigurableWebApplicationContext applicationContext;
    private DefaultListableBeanFactory parentFactory;
    private static ServletContext servletContext;
    private ContextLoader contextLoader;
    private ClientRegistry clientRegistry;
    private ServiceInvoker globalInvoker;
    private MappingStrategy globalStrategy;
    private ScopeResolver globalResolver;
    private GlobalScope global;
    private Server server;

    public void contextInitialized(ServletContextEvent sce) {
        if (null != servletContext) {
            return;
        }
        System.setProperty("red5.deployment.type", "war");
        servletContext = sce.getServletContext();
        String prefix = servletContext.getRealPath("/");
        long time = System.currentTimeMillis();
        logger.info("RED5 Server (http://www.osflash.org/red5)");
        logger.info("WAR loader");
        logger.debug("Path: " + prefix);
        try {
            this.contextLoader = this.createContextLoader();
            this.applicationContext = (ConfigurableWebApplicationContext)this.contextLoader.initWebApplicationContext(servletContext);
            logger.debug("Root context path: " + this.applicationContext.getServletContext().getContextPath());
            ConfigurableListableBeanFactory factory = this.applicationContext.getBeanFactory();
            factory.registerSingleton("default.context", (Object)this.applicationContext);
            this.parentFactory = (DefaultListableBeanFactory)factory.getParentBeanFactory();
        }
        catch (Throwable t) {
            logger.error("", t);
        }
        long startupIn = System.currentTimeMillis() - time;
        logger.info("Startup done in: " + startupIn + " ms");
    }

    public void registerSubContext(String webAppKey) {
        ServletContext ctx = servletContext.getContext(webAppKey);
        if (ctx == null) {
            ctx = servletContext;
        }
        ContextLoader loader = new ContextLoader();
        ConfigurableWebApplicationContext appCtx = (ConfigurableWebApplicationContext)loader.initWebApplicationContext(ctx);
        appCtx.setParent((ApplicationContext)this.applicationContext);
        appCtx.refresh();
        ctx.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)appCtx);
        ConfigurableListableBeanFactory appFactory = appCtx.getBeanFactory();
        logger.debug("About to grab Webcontext bean for " + webAppKey);
        Context webContext = (Context)appCtx.getBean("web.context");
        webContext.setCoreBeanFactory((BeanFactory)this.parentFactory);
        webContext.setClientRegistry(this.clientRegistry);
        webContext.setServiceInvoker(this.globalInvoker);
        webContext.setScopeResolver(this.globalResolver);
        webContext.setMappingStrategy(this.globalStrategy);
        WebScope scope = (WebScope)appFactory.getBean("web.scope");
        scope.setServer(this.server);
        scope.setParent(this.global);
        scope.register();
        scope.start();
        registeredContexts.add(ctx);
    }

    public ContextLoader getContextLoader() {
        return this.contextLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext servletContext = WarLoaderServlet.servletContext;
        synchronized (servletContext) {
            logger.info("Webapp shutdown");
            try {
                Object attr;
                ServletContext ctx = sce.getServletContext();
                Introspector.flushCaches();
                Enumeration<Driver> e = DriverManager.getDrivers();
                while (e.hasMoreElements()) {
                    Driver driver = e.nextElement();
                    if (driver.getClass().getClassLoader() != ((Object)((Object)this)).getClass().getClassLoader()) continue;
                    DriverManager.deregisterDriver(driver);
                }
                JMXAgent.shutdown();
                FilePersistenceThread persistenceThread = FilePersistenceThread.getInstance();
                if (persistenceThread != null) {
                    persistenceThread.shutdown();
                }
                if ((attr = ctx.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE)) != null) {
                    ConfigurableWebApplicationContext applicationContext = (ConfigurableWebApplicationContext)attr;
                    ConfigurableListableBeanFactory factory = applicationContext.getBeanFactory();
                    try {
                        for (String singleton : factory.getSingletonNames()) {
                            logger.debug("Registered singleton: " + singleton);
                            factory.destroyScopedBean(singleton);
                        }
                    }
                    catch (RuntimeException e2) {
                        // empty catch block
                    }
                    factory.destroySingletons();
                    ctx.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
                    applicationContext.close();
                }
                this.getContextLoader().closeWebApplicationContext(ctx);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

