/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.ant.keystore;

import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.picketbox.util.KeyStoreUtil;

public class CreateKeystore
extends Task {
    private static final String KEYSTORE_TYPE = "JCEKS";
    private String keyStore;
    private String keyStorePassword;
    private int keySize;
    private String alias;

    public void execute() throws BuildException {
        this.assertProperty("keyStore", this.keyStore);
        this.assertProperty("keyStorePassword", this.keyStorePassword);
        this.assertProperty("keySize", this.keySize);
        this.assertProperty("alias", this.alias);
        try {
            File keyStoreFile = new File(this.keyStore);
            if (!keyStoreFile.exists()) {
                KeyStore ks = KeyStoreUtil.createKeyStore((String)KEYSTORE_TYPE, (char[])this.keyStorePassword.toCharArray());
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                keyGenerator.init(this.keySize);
                SecretKey secretKey = keyGenerator.generateKey();
                KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(secretKey);
                KeyStore.PasswordProtection p = new KeyStore.PasswordProtection(this.keyStorePassword.toCharArray());
                ks.setEntry(this.alias, skEntry, p);
                ks.store(new FileOutputStream(keyStoreFile), this.keyStorePassword.toCharArray());
            }
            this.keyStore = keyStoreFile.getAbsolutePath();
        }
        catch (Exception e) {
            throw new BuildException("Problem creating keyStore: ", (Throwable)e);
        }
    }

    private void assertProperty(String propertyName, String propertyValue) throws BuildException {
        if (StringUtils.isBlank((String)propertyValue)) {
            throw new BuildException("\tThe " + propertyName + " property is required for this task.");
        }
    }

    private void assertProperty(String propertyName, int propertyValue) throws BuildException {
        if (propertyValue == 0) {
            throw new BuildException("\tThe " + propertyName + " property is required for this task.");
        }
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

