/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.jboss7;

import java.security.Principal;
import java.util.Set;
import java.util.UUID;
import org.jboss.security.SecurityContextAssociation;
import org.picketlink.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.AudienceRestrictionType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;

public class SAMLBearerTokenUtil {
    public static String createSAMLAssertion(String issuerName, String forService) {
        try {
            Principal principal = SecurityContextAssociation.getPrincipal();
            NameIDType issuer = SAMLAssertionFactory.createNameID(null, null, (String)issuerName);
            SubjectType subject = AssertionUtil.createAssertionSubject((String)principal.getName());
            AssertionType assertion = AssertionUtil.createAssertion((String)UUID.randomUUID().toString(), (NameIDType)issuer);
            assertion.setSubject(subject);
            AssertionUtil.createTimedConditions((AssertionType)assertion, (long)10000L);
            AudienceRestrictionType restriction = SAMLAssertionFactory.createAudienceRestriction((String[])new String[]{forService});
            assertion.getConditions().addCondition((ConditionAbstractType)restriction);
            SAMLBearerTokenUtil.addRoleStatements(assertion, principal);
            return AssertionUtil.asString((AssertionType)assertion);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addRoleStatements(AssertionType assertion, Principal principal) {
        AttributeType attribute = new AttributeType("Role");
        AttributeStatementType.ASTChoiceType attributeAST = new AttributeStatementType.ASTChoiceType(attribute);
        AttributeStatementType roleStatement = new AttributeStatementType();
        roleStatement.addAttribute(attributeAST);
        Set userRoles = SecurityContextAssociation.getSecurityContext().getAuthorizationManager().getUserRoles(principal);
        if (userRoles != null) {
            for (Principal role : userRoles) {
                attribute.addAttributeValue((Object)role.getName());
            }
        }
        assertion.addStatement((StatementAbstractType)roleStatement);
    }
}

