/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.filters;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PicketLinkAuthWrapperFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpSession session = req.getSession();
        Principal userPrincipal = (Principal)session.getAttribute("picketlink.principal");
        List userRoles = (List)session.getAttribute("picketlink.roles");
        if (userPrincipal != null && userRoles != null) {
            chain.doFilter(this.proxyRequest(req, userPrincipal, userRoles), response);
        } else {
            chain.doFilter((ServletRequest)req, response);
        }
    }

    private ServletRequest proxyRequest(final HttpServletRequest request, final Principal principal, final List<String> roles) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getUserPrincipal")) {
                    return principal;
                }
                if (method.getName().equals("getRemoteUser")) {
                    return principal.getName();
                }
                if (method.getName().equals("isUserInRole")) {
                    String role = (String)args[0];
                    return roles.contains(role);
                }
                return method.invoke((Object)request, args);
            }
        };
        return (HttpServletRequest)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{HttpServletRequest.class}, handler);
    }

    public void destroy() {
    }
}

