/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.dev.server.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;

public class ArchiveUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpackToWorkDir(File archiveFile, File toDir) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archiveFile);
            Enumeration zipEntries = zipFile.getEntriesInPhysicalOrder();
            while (zipEntries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)zipEntries.nextElement();
                String entryName = entry.getName();
                File outFile = new File(toDir, entryName);
                if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
                    throw new IOException("Failed to create parent directory: " + outFile.getParentFile().getCanonicalPath());
                }
                if (entry.isDirectory()) {
                    if (outFile.mkdir()) continue;
                    throw new IOException("Failed to create directory: " + outFile.getCanonicalPath());
                }
                InputStream zipStream = null;
                FileOutputStream outFileStream = null;
                zipStream = zipFile.getInputStream(entry);
                outFileStream = new FileOutputStream(outFile);
                try {
                    IOUtils.copy((InputStream)zipStream, (OutputStream)outFileStream);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)zipStream);
                    IOUtils.closeQuietly((OutputStream)outFileStream);
                }
            }
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zipFile);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zipFile);
    }
}

