/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.eap.extensions.deploy;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.overlord.commons.eap.extensions.deploy.Attribute;
import org.overlord.commons.eap.extensions.deploy.DeploymentDefinition;
import org.overlord.commons.eap.extensions.deploy.Element;
import org.overlord.commons.eap.extensions.deploy.Namespace;

public class SubsystemParser_1_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    public static final SubsystemParser_1_0 INSTANCE = new SubsystemParser_1_0();

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "overlord-deployment");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OVERLORD_DEPLOYMENT_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case DEPLOYMENTS: {
                            this.parseDeployments(reader, address, list);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void parseDeployments(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OVERLORD_DEPLOYMENT_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case DEPLOYMENT: {
                            this.parseDeployment(reader, parentAddress, list);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void parseDeployment(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        String module = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        int attrCount = reader.getAttributeCount();
        block5: for (int i = 0; i < attrCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    DeploymentDefinition.NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case MODULE: {
                    module = value;
                    DeploymentDefinition.MODULE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case VERSION: {
                    DeploymentDefinition.VERSION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        if (module == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("module"));
        }
        ModelNode address = parentAddress.clone();
        address.add("deployment", name);
        address.protect();
        operation.get("address").set(address);
        list.add(operation);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        streamWriter.writeStartElement("deployments");
        if (node.hasDefined("deployment")) {
            List deployments = node.get("deployment").asList();
            for (ModelNode deployment : deployments) {
                streamWriter.writeStartElement("deployment");
                ModelNode deploymentChild = deployment.get(0);
                this.writeAttributeIfDefined(streamWriter, deploymentChild, "name");
                this.writeAttributeIfDefined(streamWriter, deploymentChild, "module");
                this.writeAttributeIfDefined(streamWriter, deploymentChild, "version");
                streamWriter.writeEndElement();
            }
        }
        streamWriter.writeEndElement();
        streamWriter.writeEndElement();
    }

    private void writeAttributeIfDefined(XMLExtendedStreamWriter streamWriter, ModelNode node, String name) throws XMLStreamException {
        ModelNode attr;
        if (node.has(name) && (attr = node.get(name)).isDefined()) {
            streamWriter.writeAttribute(name, attr.asString());
        }
    }
}

