/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.server.rest.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.ActivityUnit;
import org.overlord.rtgov.activity.server.ActivityServer;
import org.overlord.rtgov.activity.server.QuerySpec;
import org.overlord.rtgov.activity.util.ActivityUtil;
import org.overlord.rtgov.common.util.RTGovConfig;

@Singleton
public class RESTActivityServer
implements ActivityServer {
    private static final Logger LOG = Logger.getLogger(RESTActivityServer.class.getName());
    private static final String STORE = "/overlord-rtgov/activity/store";
    private static final String UNIT = "/overlord-rtgov/activity/unit";
    private static final String QUERY = "/overlord-rtgov/activity/query";
    private static final String EVENTS = "/overlord-rtgov/activity/events";
    @Inject
    @RTGovConfig
    private String _serverURL = "http://localhost:8080";

    public void setServerURL(String url) {
        this._serverURL = url;
    }

    public String getServerURL() {
        return this._serverURL;
    }

    public void store(List<ActivityUnit> activities) throws Exception {
        URL storeUrl = new URL(this._serverURL + STORE);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer[" + storeUrl + "] store: " + activities);
        }
        LOG.info("STORE to " + storeUrl);
        HttpURLConnection connection = (HttpURLConnection)storeUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStream os = connection.getOutputStream();
        os.write(ActivityUtil.serializeActivityUnitList(activities));
        os.flush();
        os.close();
        InputStream is = connection.getInputStream();
        byte[] b = new byte[is.available()];
        is.read(b);
        is.close();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer result: " + new String(b));
        }
    }

    public ActivityUnit getActivityUnit(String id) throws Exception {
        ActivityUnit ret = null;
        URL queryUrl = new URL(this._serverURL + UNIT + "?id=" + id);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer[" + queryUrl + "] getActivityUnit: " + id);
        }
        HttpURLConnection connection = (HttpURLConnection)queryUrl.openConnection();
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        InputStream is = connection.getInputStream();
        byte[] b = new byte[is.available()];
        is.read(b);
        is.close();
        ret = ActivityUtil.deserializeActivityUnit((byte[])b);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer getActivityUnit result: " + ret);
        }
        return ret;
    }

    public List<ActivityType> getActivityTypes(String context) throws Exception {
        List ret = null;
        URL queryUrl = new URL(this._serverURL + EVENTS + "?context=" + context);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer[" + queryUrl + "] getActivityTypes: " + context);
        }
        HttpURLConnection connection = (HttpURLConnection)queryUrl.openConnection();
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        InputStream is = connection.getInputStream();
        byte[] b = new byte[is.available()];
        is.read(b);
        ret = ActivityUtil.deserializeActivityTypeList((byte[])b);
        is.close();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer getActivityTypes result: " + ret);
        }
        return ret;
    }

    public List<ActivityType> query(QuerySpec query) throws Exception {
        List ret = null;
        URL queryUrl = new URL(this._serverURL + QUERY);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer[" + queryUrl + "] query: " + query);
        }
        HttpURLConnection connection = (HttpURLConnection)queryUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStream os = connection.getOutputStream();
        byte[] b = ActivityUtil.serializeQuerySpec((QuerySpec)query);
        os.write(b);
        os.flush();
        os.close();
        InputStream is = connection.getInputStream();
        b = new byte[is.available()];
        is.read(b);
        ret = ActivityUtil.deserializeActivityTypeList((byte[])b);
        is.close();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer result: " + ret);
        }
        return ret;
    }
}

