/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.activity.interceptor.ActivityInterceptor;
import org.overlord.rtgov.activity.interceptor.ActivityInterceptorManager;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.common.util.VersionUtil;

public abstract class AbstractActivityInterceptorManager
implements ActivityInterceptorManager {
    private static final Logger LOG = Logger.getLogger(AbstractActivityInterceptorManager.class.getName());
    private Map<String, ActivityInterceptor> _activityInterceptorIndex = new HashMap<String, ActivityInterceptor>();
    private List<ActivityInterceptor> _activityInterceptors = new ArrayList<ActivityInterceptor>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ActivityInterceptor ai) throws Exception {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Register: activity interceptor name=" + ai.getName() + " version=" + ai.getVersion() + " ai=" + ai);
        }
        ai.init();
        List<ActivityInterceptor> list = this._activityInterceptors;
        synchronized (list) {
            boolean f_add = false;
            ActivityInterceptor existing = this._activityInterceptorIndex.get(ai.getName());
            if (existing != null) {
                if (VersionUtil.isNewerVersion((String)existing.getVersion(), (String)ai.getVersion())) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Replace existing activity interceptor version=" + existing.getVersion());
                    }
                    this.unregister(existing);
                    f_add = true;
                } else if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Newer version '" + existing.getVersion() + "' already registered");
                }
            } else {
                f_add = true;
            }
            if (f_add) {
                this._activityInterceptorIndex.put(ai.getName(), ai);
                this._activityInterceptors.add(ai);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityInterceptor getActivityInterceptor(String name) {
        Map<String, ActivityInterceptor> map = this._activityInterceptorIndex;
        synchronized (map) {
            return this._activityInterceptorIndex.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ActivityType actType) throws Exception {
        Map<String, ActivityInterceptor> map = this._activityInterceptorIndex;
        synchronized (map) {
            for (int i = 0; i < this._activityInterceptors.size(); ++i) {
                this._activityInterceptors.get(i).process(actType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(ActivityInterceptor ai) throws Exception {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unregister: activity interceptor name=" + ai.getName() + " version=" + ai.getVersion() + " ai=" + ai);
        }
        Map<String, ActivityInterceptor> map = this._activityInterceptorIndex;
        synchronized (map) {
            if (this._activityInterceptors.contains(ai)) {
                ActivityInterceptor removed = this._activityInterceptorIndex.remove(ai.getName());
                this._activityInterceptors.remove(removed);
            } else if (this._activityInterceptorIndex.containsKey(ai.getName()) && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Another version of activity interceptor name=" + ai.getName() + " is currently registered: existing version =" + this._activityInterceptorIndex.get(ai.getName()).getVersion());
            }
        }
    }
}

