/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.collector.activity.server;

import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.overlord.rtgov.activity.collector.BatchedActivityUnitLogger;
import org.overlord.rtgov.activity.model.ActivityUnit;
import org.overlord.rtgov.activity.server.ActivityServer;

@Singleton
public class ActivityServerLogger
extends BatchedActivityUnitLogger {
    private static final Logger LOG = Logger.getLogger(ActivityServerLogger.class.getName());
    @Inject
    private ActivityServer _activityServer = null;
    private List<ActivityUnit> _activities = null;

    @PostConstruct
    public void init() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Initialize Logger for Activity Server: " + this._activityServer);
        }
        super.init();
    }

    public void setActivityServer(ActivityServer activityServer) {
        this._activityServer = activityServer;
    }

    public ActivityServer getActivityServer() {
        return this._activityServer;
    }

    protected void appendActivity(ActivityUnit act) throws Exception {
        if (this._activities == null) {
            this._activities = new Vector<ActivityUnit>();
        }
        this._activities.add(act);
    }

    protected void sendMessage() throws Exception {
        if (this._activities != null) {
            this._activityServer.store(this._activities);
            this._activities.clear();
        }
    }

    @PreDestroy
    public void close() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Close Logger for Activity Server: " + this._activityServer);
        }
        super.close();
    }
}

