/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.epn.loader.jee;

import java.io.InputStream;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.naming.InitialContext;
import org.overlord.rtgov.epn.AbstractEPNLoader;
import org.overlord.rtgov.epn.EPNManager;
import org.overlord.rtgov.epn.Network;
import org.overlord.rtgov.epn.util.NetworkUtil;

@ApplicationScoped
@Singleton
@Startup
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class JEEEPNLoader
extends AbstractEPNLoader {
    private static final Logger LOG = Logger.getLogger(JEEEPNLoader.class.getName());
    private static final String EPN_JSON = "epn.json";
    private EPNManager _epnManager = null;
    private Network _network = null;

    @PostConstruct
    public void init() {
        try {
            InitialContext ctx = new InitialContext();
            this._epnManager = (EPNManager)ctx.lookup("java:global/overlord-rtgov/EPNManager");
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(EPN_JSON);
            if (is == null) {
                LOG.severe(PropertyResourceBundle.getBundle("epn-loader-jee.Messages").getString("EPN-LOADER-JEE-1"));
            } else {
                byte[] b = new byte[is.available()];
                is.read(b);
                is.close();
                this._network = NetworkUtil.deserialize((byte[])b);
                this.preInit(this._network);
                this._epnManager.register(this._network);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("epn-loader-jee.Messages").getString("EPN-LOADER-JEE-2"), e);
        }
    }

    @PreDestroy
    public void close() {
        if (this._epnManager != null && this._network != null) {
            try {
                this._epnManager.unregister(this._network.getName(), this._network.getVersion());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("epn-loader-jee.Messages").getString("EPN-LOADER-JEE-3"), e);
            }
        }
    }
}

