/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.jee;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.InitialContext;
import org.overlord.rtgov.activity.collector.ActivityCollector;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.app.CustomActivity;
import org.overlord.rtgov.activity.model.app.LogMessage;
import org.overlord.rtgov.jee.ActivityReporter;

public class DefaultActivityReporter
implements ActivityReporter {
    private static final Logger LOG = Logger.getLogger(DefaultActivityReporter.class.getName());
    private static final String ACTIVITY_COLLECTOR = "java:global/overlord-rtgov/ActivityCollector";
    private ActivityCollector _activityCollector = null;
    private boolean _initialized = false;

    @PostConstruct
    protected void init() {
        if (this._activityCollector == null) {
            try {
                InitialContext ctx = new InitialContext();
                this._activityCollector = (ActivityCollector)ctx.lookup(ACTIVITY_COLLECTOR);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to initialize activity collector", e);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("*********** Default Activity Reporter initialized with collector=" + this._activityCollector);
        }
        this._initialized = true;
    }

    @Override
    public void logInfo(String info) {
        LogMessage lm = new LogMessage();
        lm.setMessage(info);
        lm.setLevel(LogMessage.Level.Information);
        try {
            this.report((ActivityType)lm);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to report Info activity: " + info, e);
        }
    }

    @Override
    public void logWarning(String warning) {
        LogMessage lm = new LogMessage();
        lm.setMessage(warning);
        lm.setLevel(LogMessage.Level.Warning);
        try {
            this.report((ActivityType)lm);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to report Warning activity: " + warning, e);
        }
    }

    @Override
    public void logError(String error) {
        LogMessage lm = new LogMessage();
        lm.setMessage(error);
        lm.setLevel(LogMessage.Level.Error);
        try {
            this.report((ActivityType)lm);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to report Error activity: " + error, e);
        }
    }

    @Override
    public void report(String type, Map<String, String> props) throws Exception {
        CustomActivity ca = new CustomActivity();
        ca.setCustomType(type);
        ca.setProperties(props);
        this.report((ActivityType)ca);
    }

    @Override
    public void report(ActivityType actType) throws Exception {
        if (!this._initialized) {
            this.init();
        }
        this._activityCollector.record(actType);
    }
}

