/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.err;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SrampAtomException
extends Exception {
    private static final long serialVersionUID = -4954468657023096910L;
    private static final Pattern ST_PATTERN = Pattern.compile("([a-zA-Z0-9_\\.]*)\\.([a-zA-Z0-9_\\.]*)\\(([a-zA-Z0-9_\\.]*):([\\d]*)\\)");

    public SrampAtomException() {
    }

    public SrampAtomException(String message) {
        super(message);
    }

    public SrampAtomException(String message, Throwable cause) {
        super(message, cause);
    }

    public SrampAtomException(Throwable cause) {
        super(cause);
    }

    public SrampAtomException(String msg, String stackTrace) {
        super(msg);
        this.setStackTrace(SrampAtomException.parseStackTrace(stackTrace));
    }

    private static StackTraceElement[] parseStackTrace(String stackTrace) {
        ArrayList<StackTraceElement> stElements = new ArrayList<StackTraceElement>();
        Matcher matcher = ST_PATTERN.matcher(stackTrace);
        while (matcher.find()) {
            String className = matcher.group(1);
            String methodName = matcher.group(2);
            String fileName = matcher.group(3);
            int lineNumber = Integer.parseInt(matcher.group(4) == null ? "0" : matcher.group(4));
            stElements.add(new StackTraceElement(className, methodName, fileName, lineNumber));
        }
        return stElements.toArray(new StackTraceElement[stElements.size()]);
    }
}

