/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client.jar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.atom.archive.ArchiveUtils;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.client.jar.ArtifactFilter;
import org.overlord.sramp.client.jar.CandidateArtifact;
import org.overlord.sramp.client.jar.DefaultArtifactFilter;
import org.overlord.sramp.client.jar.DefaultMetaDataFactory;
import org.overlord.sramp.client.jar.DiscoveredArtifact;
import org.overlord.sramp.client.jar.DiscoveredArtifacts;
import org.overlord.sramp.client.jar.JarToSrampArchiveException;
import org.overlord.sramp.client.jar.MetaDataFactory;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class JarToSrampArchive {
    private File originalJar;
    private boolean shouldDeleteOriginalJar;
    private File jarWorkDir;
    private static final ArtifactFilter DEFAULT_ARTIFACT_FILTER = new DefaultArtifactFilter();
    private ArtifactFilter artifactFilter = DEFAULT_ARTIFACT_FILTER;
    private static final MetaDataFactory DEFAULT_META_DATA_FACTORY = new DefaultMetaDataFactory();
    private MetaDataFactory metaDataFactory = DEFAULT_META_DATA_FACTORY;

    public JarToSrampArchive(File jar) throws JarToSrampArchiveException {
        this.originalJar = jar;
        this.shouldDeleteOriginalJar = false;
        this.jarWorkDir = null;
        try {
            this.jarWorkDir = JarToSrampArchive.createJarWorkDir();
            ArchiveUtils.unpackToWorkDir((File)this.originalJar, (File)this.jarWorkDir);
        }
        catch (IOException e) {
            if (this.jarWorkDir != null) {
                try {
                    FileUtils.deleteDirectory((File)this.jarWorkDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new JarToSrampArchiveException(e);
        }
    }

    public JarToSrampArchive(InputStream jarStream) throws JarToSrampArchiveException {
        this.originalJar = null;
        this.shouldDeleteOriginalJar = true;
        this.jarWorkDir = null;
        try {
            this.originalJar = File.createTempFile("j2sramp", ".jar");
            JarToSrampArchive.copyJarStream(jarStream, this.originalJar);
            this.jarWorkDir = JarToSrampArchive.createJarWorkDir();
            ArchiveUtils.unpackToWorkDir((File)this.originalJar, (File)this.jarWorkDir);
        }
        catch (IOException e) {
            if (this.jarWorkDir != null) {
                try {
                    FileUtils.deleteDirectory((File)this.jarWorkDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.originalJar != null && this.originalJar.exists()) {
                this.originalJar.delete();
            }
            throw new JarToSrampArchiveException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyJarStream(InputStream jarStream, File jarOutputFile) throws IOException {
        FileOutputStream oStream = null;
        try {
            oStream = FileUtils.openOutputStream((File)jarOutputFile);
            IOUtils.copy((InputStream)jarStream, (OutputStream)oStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)jarStream);
            IOUtils.closeQuietly((OutputStream)oStream);
        }
    }

    private static File createJarWorkDir() throws IOException {
        File tempFile = File.createTempFile("j2sramp", ".work");
        tempFile.delete();
        tempFile.mkdir();
        return tempFile;
    }

    public SrampArchive createSrampArchive() throws JarToSrampArchiveException {
        DiscoveredArtifacts discoveredArtifacts = this.discoverArtifacts();
        discoveredArtifacts.index(this.jarWorkDir);
        this.generateMetaData(discoveredArtifacts);
        try {
            SrampArchive archive = new SrampArchive();
            for (DiscoveredArtifact artifact : discoveredArtifacts) {
                String path = artifact.getArchivePath();
                archive.addEntry(path, artifact.getMetaData(), artifact.getContent());
            }
            return archive;
        }
        catch (Exception e) {
            throw new JarToSrampArchiveException(e);
        }
    }

    private void generateMetaData(DiscoveredArtifacts discoveredArtifacts) {
        for (DiscoveredArtifact artifact : discoveredArtifacts) {
            BaseArtifactType metaData = this.metaDataFactory.createMetaData(artifact);
            artifact.setMetaData(metaData);
        }
    }

    private DiscoveredArtifacts discoverArtifacts() {
        DiscoveredArtifacts artifacts = new DiscoveredArtifacts();
        Collection files = FileUtils.listFiles((File)this.jarWorkDir, null, (boolean)true);
        for (File file : files) {
            CandidateArtifact candidate = new CandidateArtifact(file);
            if (!this.artifactFilter.accepts(candidate)) continue;
            artifacts.add(file);
        }
        return artifacts;
    }

    public void close() throws IOException {
        FileUtils.deleteDirectory((File)this.jarWorkDir);
        if (this.shouldDeleteOriginalJar) {
            this.originalJar.delete();
        }
    }

    public void setArtifactFilter(ArtifactFilter artifactFilter) {
        this.artifactFilter = artifactFilter;
    }

    public void setMetaDataFactory(MetaDataFactory metaDataFactory) {
        this.metaDataFactory = metaDataFactory;
    }

    public static void closeQuietly(JarToSrampArchive j2sramp) {
        try {
            if (j2sramp != null) {
                j2sramp.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

