/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client.query;

import java.util.Iterator;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.common.SrampConstants;

public class QueryResultSet
implements Iterable<ArtifactSummary> {
    private Feed currentFeed;

    public QueryResultSet(Feed feed) {
        this.currentFeed = feed;
    }

    public long size() {
        return this.currentFeed.getEntries().size();
    }

    public long getTotalResults() {
        Object totalResultsAttr = this.currentFeed.getExtensionAttributes().get(SrampConstants.SRAMP_TOTAL_RESULTS_QNAME);
        if (totalResultsAttr != null) {
            return Long.parseLong((String)totalResultsAttr);
        }
        return -1L;
    }

    public int getItemsPerPage() {
        Object itemsPerPageAttr = this.currentFeed.getExtensionAttributes().get(SrampConstants.SRAMP_ITEMS_PER_PAGE_QNAME);
        if (itemsPerPageAttr != null) {
            return Integer.parseInt((String)itemsPerPageAttr);
        }
        return -1;
    }

    public int getStartIndex() {
        Object startIndexAttr = this.currentFeed.getExtensionAttributes().get(SrampConstants.SRAMP_START_INDEX_QNAME);
        if (startIndexAttr != null) {
            return Integer.parseInt((String)startIndexAttr);
        }
        return -1;
    }

    public ArtifactSummary get(int index) {
        if (index >= this.currentFeed.getEntries().size()) {
            return null;
        }
        return new ArtifactSummary((Entry)this.currentFeed.getEntries().get(index));
    }

    @Override
    public Iterator<ArtifactSummary> iterator() {
        return new DelegatingIterator(this.currentFeed.getEntries().iterator());
    }

    private static class DelegatingIterator
    implements Iterator<ArtifactSummary> {
        private Iterator<Entry> delegate;

        public DelegatingIterator(Iterator<Entry> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public ArtifactSummary next() {
            return new ArtifactSummary(this.delegate.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

