/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.query.xpath;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.query.xpath.DefaultNamespaceContext;
import org.overlord.sramp.common.query.xpath.TokenStream;
import org.overlord.sramp.common.query.xpath.TokenType;
import org.overlord.sramp.common.query.xpath.XPathParserException;
import org.overlord.sramp.common.query.xpath.XPathTokenizer;
import org.overlord.sramp.common.query.xpath.ast.AndExpr;
import org.overlord.sramp.common.query.xpath.ast.Argument;
import org.overlord.sramp.common.query.xpath.ast.ArtifactSet;
import org.overlord.sramp.common.query.xpath.ast.EqualityExpr;
import org.overlord.sramp.common.query.xpath.ast.Expr;
import org.overlord.sramp.common.query.xpath.ast.ForwardPropertyStep;
import org.overlord.sramp.common.query.xpath.ast.FunctionCall;
import org.overlord.sramp.common.query.xpath.ast.LocationPath;
import org.overlord.sramp.common.query.xpath.ast.OrExpr;
import org.overlord.sramp.common.query.xpath.ast.Predicate;
import org.overlord.sramp.common.query.xpath.ast.PrimaryExpr;
import org.overlord.sramp.common.query.xpath.ast.Query;
import org.overlord.sramp.common.query.xpath.ast.RelationshipPath;
import org.overlord.sramp.common.query.xpath.ast.SubartifactSet;

public class XPathParser {
    private NamespaceContext namespaceContext;
    private String defaultPrefix;

    public XPathParser() {
        this.setNamespaceContext(new DefaultNamespaceContext());
        this.setDefaultPrefix("s-ramp");
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    public void setDefaultPrefix(String defaultPrefix) {
        this.defaultPrefix = defaultPrefix;
    }

    public Query parseXPath(String xpath) {
        XPathTokenizer tokenizer = new XPathTokenizer();
        try {
            TokenStream tokens = tokenizer.tokenize(xpath);
            return this.parseQuery(tokens);
        }
        catch (ParseException e) {
            throw new XPathParserException(e.getMessage());
        }
    }

    protected Query parseQuery(TokenStream tokens) {
        Query query = new Query();
        ArtifactSet artifactSet = this.parseArtifactSet(tokens);
        query.setArtifactSet(artifactSet);
        if (tokens.canConsume("[")) {
            Predicate predicate = this.parsePredicate(tokens);
            query.setPredicate(predicate);
            if (!tokens.canConsume("]")) {
                throw new XPathParserException("Artifact-set predicate not terminated.");
            }
        }
        if (tokens.canConsume("/")) {
            SubartifactSet subartifactSet = this.parseSubartifactSet(tokens);
            query.setSubartifactSet(subartifactSet);
        }
        if (tokens.hasNext()) {
            throw new XPathParserException("Query string improperly terminated (found extra data)");
        }
        return query;
    }

    private ArtifactSet parseArtifactSet(TokenStream tokens) {
        ArtifactSet artifactSet = new ArtifactSet();
        LocationPath locationPath = this.parseLocationPath(tokens);
        artifactSet.setLocationPath(locationPath);
        return artifactSet;
    }

    private LocationPath parseLocationPath(TokenStream tokens) {
        String artifactModel = null;
        String artifactType = null;
        if (!tokens.canConsume("/")) {
            throw new XPathParserException("Relative XPath queries not supported.");
        }
        if (!tokens.matches(TokenType.name) && !tokens.matches("/")) {
            throw new XPathParserException("Invalid artifact set (step 1).");
        }
        if (tokens.matches("/")) {
            tokens.consume().toString();
            if (!tokens.matches(TokenType.name)) {
                throw new XPathParserException("Empty // is an invalid query (expected '//{artifactType}').");
            }
            artifactType = tokens.consume().toString();
            artifactModel = this.resolveArtifactModel(artifactType);
        } else {
            String rootSrampSegment = tokens.consume().toString();
            if (!"s-ramp".equals(rootSrampSegment)) {
                throw new XPathParserException("Query must begin with /s-ramp or //).");
            }
            if (tokens.hasNext() && !tokens.matches("[")) {
                if (!tokens.canConsume("/")) {
                    throw new XPathParserException("Invalid artifact set (step 2).");
                }
                if (!tokens.matches(TokenType.name)) {
                    throw new XPathParserException("Invalid artifact set (step 2).");
                }
                artifactModel = tokens.consume().toString();
                if (tokens.hasNext() && !tokens.matches("[")) {
                    if (!tokens.canConsume("/")) {
                        throw new XPathParserException("Invalid artifact set (step 3).");
                    }
                    if (!tokens.matches(TokenType.name)) {
                        throw new XPathParserException("Invalid artifact set (step 3).");
                    }
                    artifactType = tokens.consume().toString();
                }
            }
        }
        LocationPath locationPath = new LocationPath();
        locationPath.setArtifactModel(artifactModel);
        locationPath.setArtifactType(artifactType);
        return locationPath;
    }

    private Predicate parsePredicate(TokenStream tokens) {
        Expr expr = this.parseExpr(tokens);
        Predicate predicate = new Predicate();
        predicate.setExpr(expr);
        return predicate;
    }

    private Expr parseExpr(TokenStream tokens) {
        AndExpr andExpr = this.parseAndExpr(tokens);
        Expr expr = new Expr();
        expr.setAndExpr(andExpr);
        return expr;
    }

    private AndExpr parseAndExpr(TokenStream tokens) {
        AndExpr andExpr = new AndExpr();
        OrExpr left = this.parseOrExpr(tokens);
        andExpr.setLeft(left);
        if (tokens.canConsume("and")) {
            AndExpr right = this.parseAndExpr(tokens);
            andExpr.setRight(right);
        }
        return andExpr;
    }

    private OrExpr parseOrExpr(TokenStream tokens) {
        OrExpr orExpr = new OrExpr();
        EqualityExpr left = this.parseEqualityExpr(tokens);
        orExpr.setLeft(left);
        if (tokens.canConsume("or")) {
            OrExpr right = this.parseOrExpr(tokens);
            orExpr.setRight(right);
        }
        return orExpr;
    }

    private EqualityExpr parseEqualityExpr(TokenStream tokens) {
        EqualityExpr equalityExpr = new EqualityExpr();
        if (tokens.canConsume("(")) {
            Expr expr = this.parseExpr(tokens);
            equalityExpr.setExpr(expr);
            if (!tokens.canConsume(")")) {
                throw new XPathParserException("Missing close-paren ')' in expression.");
            }
        } else if (tokens.canConsume("@")) {
            ForwardPropertyStep forwardPropertyStep = this.parseForwardPropertyStep(tokens);
            PrimaryExpr primaryExpr = null;
            if (tokens.canConsume("!", "=")) {
                equalityExpr.setOperator(EqualityExpr.Operator.NE);
                primaryExpr = this.parsePrimaryExpr(tokens);
            } else if (tokens.canConsume("<", "=")) {
                equalityExpr.setOperator(EqualityExpr.Operator.LTE);
                primaryExpr = this.parsePrimaryExpr(tokens);
            } else if (tokens.canConsume(">", "=")) {
                equalityExpr.setOperator(EqualityExpr.Operator.GTE);
                primaryExpr = this.parsePrimaryExpr(tokens);
            } else if (tokens.matchesAnyOf("=", "<", ">")) {
                String symbol = tokens.consume().toString();
                EqualityExpr.Operator operator = EqualityExpr.Operator.valueOfSymbol(symbol);
                equalityExpr.setOperator(operator);
                primaryExpr = this.parsePrimaryExpr(tokens);
            }
            equalityExpr.setLeft(forwardPropertyStep);
            equalityExpr.setRight(primaryExpr);
        } else {
            SubartifactSet subartifactSet = this.parseSubartifactSet(tokens);
            equalityExpr.setSubArtifactSet(subartifactSet);
        }
        return equalityExpr;
    }

    private ForwardPropertyStep parseForwardPropertyStep(TokenStream tokens) {
        ForwardPropertyStep forwardPropertyStep = new ForwardPropertyStep();
        QName propertyQName = this.parseQName(tokens, null);
        forwardPropertyStep.setPropertyQName(propertyQName);
        return forwardPropertyStep;
    }

    private QName parseQName(TokenStream tokens, String defaultPrefix) {
        String prefix = null;
        String localPart = null;
        String namespace = null;
        if (!tokens.matches(TokenType.name)) {
            throw new XPathParserException("Expected NAME type token.");
        }
        String ncname1 = tokens.consume().toString();
        if (tokens.canConsume(":")) {
            if (!tokens.matches(TokenType.name)) {
                throw new XPathParserException("Expected NAME type token.");
            }
            String ncname2 = tokens.consume().toString();
            prefix = ncname1;
            localPart = ncname2;
        } else {
            prefix = defaultPrefix;
            localPart = ncname1;
        }
        namespace = this.getNamespaceContext().getNamespaceURI(prefix);
        if (prefix == null) {
            prefix = "";
        }
        return new QName(namespace, localPart, prefix);
    }

    private PrimaryExpr parsePrimaryExpr(TokenStream tokens) {
        PrimaryExpr primaryExpr = new PrimaryExpr();
        if (tokens.canConsume("$")) {
            QName propertyQName = this.parseQName(tokens, null);
            primaryExpr.setPropertyQName(propertyQName);
        } else if (tokens.matches(TokenType.quotedString)) {
            String literal = tokens.consume().toString();
            literal = this.removeQuotes(literal);
            primaryExpr.setLiteral(literal);
        } else if (tokens.matches(TokenType.numeric)) {
            String numberStr = tokens.consume().toString();
            Number number = null;
            try {
                number = numberStr.contains(".") ? new Double(numberStr) : new BigInteger(numberStr);
            }
            catch (NumberFormatException e) {
                throw new XPathParserException("Invalid numeric literal.");
            }
            primaryExpr.setNumber(number);
        } else {
            throw new XPathParserException("Expected a primary expression (string literal, number, etc).");
        }
        return primaryExpr;
    }

    private SubartifactSet parseSubartifactSet(TokenStream tokens) {
        if (!tokens.matches(TokenType.name) && !tokens.matches(".")) {
            throw new XPathParserException("Expression expected.");
        }
        SubartifactSet subartifactSet = new SubartifactSet();
        String relationshipOrFunction = tokens.consume().toString();
        if (tokens.canConsume("[")) {
            RelationshipPath relationshipPath = new RelationshipPath(relationshipOrFunction);
            Predicate predicate = this.parsePredicate(tokens);
            if (!tokens.canConsume("]")) {
                throw new XPathParserException("Unterminated predicate in subartifact-set.");
            }
            subartifactSet.setRelationshipPath(relationshipPath);
            subartifactSet.setPredicate(predicate);
            if (tokens.canConsume("/")) {
                SubartifactSet sub_subartifactSet = this.parseSubartifactSet(tokens);
                subartifactSet.setSubartifactSet(sub_subartifactSet);
            }
        } else if (tokens.canConsume(":")) {
            String prefix = relationshipOrFunction;
            if (!tokens.matches(TokenType.name)) {
                throw new XPathParserException("Expected function name.");
            }
            String localName = tokens.consume().toString();
            String namespace = this.getNamespaceContext().getNamespaceURI(prefix);
            QName functionName = new QName(namespace, localName, prefix);
            if (!tokens.matches("(")) {
                throw new XPathParserException("Expected function arguments.");
            }
            List<Argument> arguments = this.parseFunctionArguments(tokens);
            FunctionCall functionCall = new FunctionCall();
            functionCall.setFunctionName(functionName);
            functionCall.setArguments(arguments);
            subartifactSet.setFunctionCall(functionCall);
        } else if (tokens.matches("(")) {
            String prefix = this.getDefaultPrefix();
            String localName = relationshipOrFunction;
            String namespace = this.getNamespaceContext().getNamespaceURI(prefix);
            QName functionName = new QName(namespace, localName, prefix);
            List<Argument> arguments = this.parseFunctionArguments(tokens);
            FunctionCall functionCall = new FunctionCall();
            functionCall.setFunctionName(functionName);
            functionCall.setArguments(arguments);
            subartifactSet.setFunctionCall(functionCall);
        } else {
            RelationshipPath relationshipPath = new RelationshipPath(relationshipOrFunction);
            subartifactSet.setRelationshipPath(relationshipPath);
        }
        return subartifactSet;
    }

    private List<Argument> parseFunctionArguments(TokenStream tokens) {
        tokens.consume().toString();
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        if (!tokens.matches(")")) {
            boolean hasMoreArguments = true;
            while (hasMoreArguments) {
                Argument argument = this.parseArgument(tokens);
                arguments.add(argument);
                hasMoreArguments = tokens.canConsume(",");
            }
        }
        if (!tokens.canConsume(")")) {
            throw new XPathParserException("Unterminated argument list.");
        }
        return arguments;
    }

    private Argument parseArgument(TokenStream tokens) {
        Argument argument = new Argument();
        if (tokens.matchesAnyOf(TokenType.quotedString, TokenType.numeric) || tokens.matches("$")) {
            PrimaryExpr primaryExpr = this.parsePrimaryExpr(tokens);
            argument.setPrimaryExpr(primaryExpr);
        } else {
            Expr expr = this.parseExpr(tokens);
            argument.setExpr(expr);
        }
        return argument;
    }

    protected String removeQuotes(String text) {
        char first = text.charAt(0);
        text = text.substring(1, text.length() - 1);
        String unescapeFrom = String.valueOf(first) + String.valueOf(first);
        String unescapeTo = String.valueOf(first);
        text = text.replace(unescapeFrom, unescapeTo);
        return text;
    }

    private String resolveArtifactModel(String artifactType) {
        return ArtifactType.valueOf(artifactType).getArtifactType().getModel();
    }
}

