/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.ontology;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SrampOntology {
    private String uuid;
    private String label;
    private String comment;
    private String base;
    private String id;
    private String createdBy;
    private Date createdOn;
    private String lastModifiedBy;
    private Date lastModifiedOn;
    private List<Class> rootClasses = new ArrayList<Class>();
    private Map<URI, Class> classIndexByUri = new HashMap<URI, Class>();
    private Map<String, Class> classIndexById = new HashMap<String, Class>();

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Class> getRootClasses() {
        return this.rootClasses;
    }

    public List<Class> getAllClasses() {
        ArrayList<Class> allClasses = new ArrayList<Class>();
        this.addAllClasses(allClasses, this.getRootClasses());
        return allClasses;
    }

    private void addAllClasses(List<Class> allClasses, List<Class> classes) {
        allClasses.addAll(classes);
        for (Class c : classes) {
            this.addAllClasses(allClasses, c.getChildren());
        }
    }

    public void setRootClasses(List<Class> rootClasses) {
        this.rootClasses = rootClasses;
    }

    public Class createClass(String id) {
        Class c = new Class();
        c.setId(id);
        String uri = this.getBase() + "#" + id;
        try {
            c.setUri(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return c;
    }

    public synchronized Class findClass(String id) {
        Class candidate;
        if (this.classIndexById.containsKey(id)) {
            return this.classIndexById.get(id);
        }
        Class found = null;
        Iterator<Class> i$ = this.rootClasses.iterator();
        while (i$.hasNext() && (found = (candidate = i$.next()).findClass(id)) == null) {
        }
        if (found != null) {
            this.classIndexById.put(id, found);
        }
        return found;
    }

    public synchronized Class findClass(URI uri) {
        Class candidate;
        if (this.classIndexByUri.containsKey(uri)) {
            return this.classIndexByUri.get(uri);
        }
        Class found = null;
        Iterator<Class> i$ = this.rootClasses.iterator();
        while (i$.hasNext() && (found = (candidate = i$.next()).findClass(uri)) == null) {
        }
        if (found != null) {
            this.classIndexByUri.put(uri, found);
        }
        return found;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setLastModifiedOn(Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public static class Class {
        private String id;
        private String label;
        private String comment;
        private URI uri;
        private Class parent;
        private List<Class> children = new ArrayList<Class>();

        public Class findClass(String id) {
            if (this.id.equals(id)) {
                return this;
            }
            for (Class c : this.children) {
                Class found = c.findClass(id);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        public Class findClass(URI uri) {
            if (this.uri.equals(uri)) {
                return this;
            }
            for (Class c : this.children) {
                Class found = c.findClass(uri);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public Class getParent() {
            return this.parent;
        }

        public void setParent(Class parent) {
            this.parent = parent;
        }

        public List<Class> getChildren() {
            return this.children;
        }

        public void setChildren(List<Class> children) {
            this.children = children;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public Set<URI> normalize() {
            HashSet<URI> uris = new HashSet<URI>();
            for (Class current = this; current != null; current = current.getParent()) {
                uris.add(current.getUri());
            }
            return uris;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

