/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.query.xpath;

public class CharacterStream {
    private char[] stream;
    private int nextIndex;

    public CharacterStream(String input) {
        this.stream = input.toCharArray();
        this.nextIndex = 0;
    }

    public boolean hasNext() {
        return this.nextIndex < this.stream.length;
    }

    public char next() {
        return this.stream[this.nextIndex++];
    }

    public boolean isNext(String values) {
        char[] charValues = values.toCharArray();
        return this.isNext(charValues);
    }

    public boolean isNext(char ... values) {
        if (!this.hasNext()) {
            return false;
        }
        for (char value : values) {
            if (this.stream[this.nextIndex] != value) continue;
            return true;
        }
        return false;
    }

    public boolean isNextNumericStart() {
        return this.isNext("0123456789");
    }

    public boolean isNextNumeric() {
        return this.isNext("0123456789.-+eE");
    }

    public boolean isNextValidXmlNcNameCharacter() {
        if (!this.hasNext()) {
            return false;
        }
        char c = this.stream[this.nextIndex];
        return Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_';
    }

    public boolean areNext(char ... values) {
        for (int idx = 0; idx < values.length; ++idx) {
            char actual;
            char expected = values[idx];
            int streamIdx = this.nextIndex + idx;
            if (streamIdx >= this.stream.length || (actual = this.stream[streamIdx]) == expected) continue;
            return false;
        }
        return true;
    }

    public int index() {
        return this.nextIndex - 1;
    }

    public String get(int startIndex, int endIndex) {
        return String.valueOf(this.stream, startIndex, endIndex - startIndex);
    }
}

