/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.repository.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.infinispan.schematic.document.ParsingException;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.JcrRepositoryFactory;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.AnonymousCredentials;
import org.modeshape.jcr.api.RepositoryFactory;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRRepository {
    private static Logger log = LoggerFactory.getLogger(JCRRepository.class);
    private static String WORKSPACE_NAME = "default";
    private static Repository repository = null;
    private static javax.jcr.RepositoryFactory theFactory = null;

    private static synchronized Repository getInstance() throws RepositoryException {
        try {
            if (repository == null) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                URL configUrl = Repository.class.getClassLoader().getResource("modeshape-sramp-config.json");
                RepositoryConfiguration config = RepositoryConfiguration.read((URL)configUrl);
                Problems problems = config.validate();
                if (problems.hasErrors()) {
                    throw new RepositoryException(problems.toString());
                }
                parameters.put("org.modeshape.jcr.URL", configUrl.toExternalForm());
                Iterator<javax.jcr.RepositoryFactory> i$ = ServiceLoader.load(javax.jcr.RepositoryFactory.class).iterator();
                while (i$.hasNext()) {
                    javax.jcr.RepositoryFactory factory;
                    theFactory = factory = i$.next();
                    repository = factory.getRepository(parameters);
                    if (repository == null) continue;
                    break;
                }
                if (repository == null) {
                    throw new RepositoryException("ServiceLoader could not instantiate JCR Repository");
                }
                JCRRepository.configureNodeTypes();
            }
        }
        catch (ParsingException e) {
            new RepositoryException((Throwable)e);
        }
        return repository;
    }

    public static void shutdown() {
        if (theFactory instanceof JcrRepositoryFactory) {
            try {
                RepositoryFactory modeRepo = (RepositoryFactory)theFactory;
                Boolean state = (Boolean)modeRepo.shutdown().get();
                log.info("called shutdown on ModeShape, with resulting state=" + state);
                repository = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public static Session getSession() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        AnonymousCredentials cred = new AnonymousCredentials();
        return JCRRepository.getInstance().login((Credentials)cred, WORKSPACE_NAME);
    }

    public static void logoutQuietly(Session session) {
        if (session != null) {
            try {
                session.logout();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void configureNodeTypes() throws RepositoryException {
        Session session = null;
        InputStream is = null;
        try {
            session = JCRRepository.getSession();
            NamespaceRegistry namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
            namespaceRegistry.registerNamespace("sramp", "http://s-ramp.org/xmlns/2010/s-ramp");
            namespaceRegistry.registerNamespace("sramp-properties", "http://s-ramp.org/xmlns/2010/s-ramp#properties");
            NodeTypeManager manager = (NodeTypeManager)session.getWorkspace().getNodeTypeManager();
            is = JCRRepository.class.getResourceAsStream("/org/overlord/s-ramp/sramp.cnd");
            manager.registerNodeTypes(is, true);
        }
        catch (LoginException e) {
            try {
                throw e;
                catch (NoSuchWorkspaceException e2) {
                    throw e2;
                }
                catch (RepositoryException e3) {
                    throw e3;
                }
                catch (IOException e4) {
                    throw new RepositoryException((Throwable)e4);
                }
                catch (RuntimeException e5) {
                    throw e5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                JCRRepository.logoutQuietly(session);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        JCRRepository.logoutQuietly(session);
    }
}

