/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.overlord.sramp.server.atom.services;

import org.junit.BeforeClass;
import org.overlord.sramp.common.SrampConstants;

/**
 * Base class for s-ramp resource tests. Handles some of the setup boilerplate.
 *
 * @author eric.wittmann@redhat.com
 */
public abstract class AbstractAuditingResourceTest extends AbstractResourceTest {

	@BeforeClass
	public static void setUp() throws Exception {
        System.setProperty(SrampConstants.SRAMP_CONFIG_AUDITING, "false");
        setUpResourceTest();
	}
}
