/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.EventProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.JobBuilder;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.EnvTool;

public class ThrowingSignalEvent
extends AbstractActivity {
    private static final long serialVersionUID = 964406244645103100L;

    protected ThrowingSignalEvent() {
    }

    public ThrowingSignalEvent(String eventName) {
        super(eventName);
    }

    @Override
    protected boolean bodyStartAutomatically() {
        return true;
    }

    @Override
    protected boolean executeBusinessLogic(Execution execution) {
        InternalProcessDefinition processDefinition = execution.getProcessDefinition();
        EventService eventService = EnvTool.getEventService();
        InternalActivityDefinition activity = execution.getNode();
        List<EventProcessDefinition> eventSubProcesses = processDefinition.getEventSubProcesses();
        if (!eventSubProcesses.isEmpty()) {
            ArrayList<String> processNames = new ArrayList<String>();
            for (EventProcessDefinition eventProcessDefinition : eventSubProcesses) {
                String processName = eventProcessDefinition.getName();
                processNames.add(processName);
            }
            String signalCode = activity.getTimerCondition();
            IncomingEventInstance signalSubProcess = eventService.getSignalStartIncomingEvent(processNames, signalCode);
            if (signalSubProcess != null) {
                this.throwEvent(eventService, activity);
                return false;
            }
        }
        Set<TransitionDefinition> outgoingTransitions = activity.getOutgoingTransitions();
        Set<TransitionDefinition> incomingTransitions = activity.getIncomingTransitions();
        if (!outgoingTransitions.isEmpty() && !incomingTransitions.isEmpty()) {
            this.throwEvent(eventService, activity);
        } else if (outgoingTransitions.isEmpty()) {
            this.throwEvent(eventService, activity);
            InternalProcessInstance instance = execution.getInstance();
            if (instance.getParentInstanceUUID() != null) {
                return false;
            }
        }
        return true;
    }

    private void throwEvent(EventService eventService, InternalActivityDefinition activity) {
        String signalCode = activity.getTimerCondition();
        Set<IncomingEventInstance> signalIncomingEvents = eventService.getSignalIncomingEvents(signalCode);
        for (IncomingEventInstance signalIncomingEvent : signalIncomingEvents) {
            InternalProcessInstance processInstance;
            ProcessInstanceUUID instanceUUID;
            Job signal = null;
            if (signalIncomingEvent.getSignal().equals("event.start.signal")) {
                signal = JobBuilder.startSignalJob(signalIncomingEvent.getName(), signalIncomingEvent.getActivityDefinitionUUID());
                signal.setEventSubProcessRootInstanceUUID(signalIncomingEvent.getEventSubProcessRootInstanceUUID());
            } else if (signalIncomingEvent.getSignal().equals("event.boundary.signal")) {
                instanceUUID = signalIncomingEvent.getInstanceUUID();
                processInstance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
                signal = JobBuilder.boundarySignalJob(signalIncomingEvent.getActivityName(), processInstance.getRootInstanceUUID(), signalIncomingEvent.getExecutionUUID(), signalIncomingEvent.getInstanceUUID());
                eventService.removeEvent(signalIncomingEvent);
            } else {
                instanceUUID = signalIncomingEvent.getInstanceUUID();
                processInstance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
                signal = JobBuilder.intermediateSignalJob(signalIncomingEvent.getName(), processInstance.getRootInstanceUUID(), signalIncomingEvent.getExecutionUUID(), signalIncomingEvent.getInstanceUUID());
                eventService.removeEvent(signalIncomingEvent);
            }
            eventService.storeJob(signal);
        }
    }
}

