/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env;

import org.ow2.bonita.env.EnvironmentFactory;
import org.ow2.bonita.env.PvmEnvironmentFactory;
import org.ow2.bonita.env.WireContext;
import org.ow2.bonita.env.WireDefinition;
import org.ow2.bonita.env.xml.WireParser;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.stream.StreamSource;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PvmEnvironmentFactoryParser
extends Parser {
    WireParser environmentFactoryXmlParser = new WireParser();
    WireParser environmentXmlParser = new WireParser();
    protected static final PvmEnvironmentFactoryParser INSTANCE = new PvmEnvironmentFactoryParser();

    public static PvmEnvironmentFactoryParser getInstance() {
        return INSTANCE;
    }

    static EnvironmentFactory parse(StreamSource streamSource) {
        Parse parse = PvmEnvironmentFactoryParser.getInstance().createParse().setStreamSource(streamSource).execute();
        Misc.showProblems(parse.getProblems(), "environment configuration " + streamSource);
        return (EnvironmentFactory)parse.getDocumentObject();
    }

    @Override
    public Object parseDocument(Document document, Parse parse) {
        Element documentElement = document.getDocumentElement();
        PvmEnvironmentFactory pvmEnvironmentFactory = (PvmEnvironmentFactory)parse.getDocumentObject();
        if (pvmEnvironmentFactory == null) {
            pvmEnvironmentFactory = new PvmEnvironmentFactory();
            parse.setDocumentObject(pvmEnvironmentFactory);
        }
        WireDefinition environmentFactoryWireDefinition = this.getApplicationWireDefinition(documentElement, parse);
        WireDefinition environmentWireDefinition = this.getBlockWireDefinition(documentElement, parse);
        WireContext environmentFactoryWireContext = new WireContext(environmentFactoryWireDefinition, "environment-factory");
        environmentFactoryWireContext.setClassLoader(this.classLoader);
        pvmEnvironmentFactory.setEnvironmentFactoryCtxWireContext(environmentFactoryWireContext);
        pvmEnvironmentFactory.setEnvironmentCtxWireDefinition(environmentWireDefinition);
        parse.setDocumentObject(pvmEnvironmentFactory);
        return pvmEnvironmentFactory;
    }

    WireDefinition getApplicationWireDefinition(Element documentElement, Parse parse) {
        Element applicationElement = XmlUtil.element(documentElement, "environment-factory");
        if (applicationElement != null) {
            return (WireDefinition)this.environmentFactoryXmlParser.parseDocumentElement(applicationElement, parse);
        }
        return null;
    }

    WireDefinition getBlockWireDefinition(Element documentElement, Parse parse) {
        Element blockElement = XmlUtil.element(documentElement, "environment");
        if (blockElement != null) {
            return (WireDefinition)this.environmentXmlParser.parseDocumentElement(blockElement, parse);
        }
        return null;
    }

    public WireParser getEnvironmentFactoryXmlParser() {
        return this.environmentFactoryXmlParser;
    }

    public void setEnvironmentFactoryXmlParser(WireParser applicationWireXmlParser) {
        this.environmentFactoryXmlParser = applicationWireXmlParser;
    }

    public WireParser getEnvironmentXmlParser() {
        return this.environmentXmlParser;
    }

    public void setEnvironmentXmlParser(WireParser blockWireXmlParser) {
        this.environmentXmlParser = blockWireXmlParser;
    }
}

